/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import java.util.Objects;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Hints;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GeneratorResult {
    private static final Hints EMPTY_HINTS = Hints.afterGenerate(AfterGenerate.DO_NOT_MODIFY);
    private static final GeneratorResult NULL_RESULT = new GeneratorResult(null, EMPTY_HINTS, Type.NULL);
    private static final GeneratorResult EMPTY_RESULT = new GeneratorResult(null, EMPTY_HINTS, Type.EMPTY);
    private static final GeneratorResult IGNORED_RESULT = new GeneratorResult(null, EMPTY_HINTS, Type.IGNORED);
    private static final GeneratorResult DELAYED_RESULT = new GeneratorResult(null, EMPTY_HINTS, Type.DELAYED);
    private final Object value;
    private final Hints hints;
    private final Type type;

    private GeneratorResult(@Nullable Object value, @NotNull Hints hints, Type type) {
        this.value = value;
        this.hints = Objects.requireNonNull(hints, "null hints");
        this.type = type;
    }

    public static GeneratorResult create(@Nullable Object value, Hints hints) {
        return new GeneratorResult(value, hints, Type.NORMAL);
    }

    public Object getValue() {
        return this.value;
    }

    public Hints getHints() {
        return this.hints;
    }

    public static GeneratorResult nullResult() {
        return NULL_RESULT;
    }

    public static GeneratorResult emptyResult() {
        return EMPTY_RESULT;
    }

    public static GeneratorResult ignoredResult() {
        return IGNORED_RESULT;
    }

    public static GeneratorResult delayed() {
        return DELAYED_RESULT;
    }

    public boolean hasEmitNullHint() {
        InternalGeneratorHint hint = this.hints.get(InternalGeneratorHint.class);
        return hint != null && hint.emitNull();
    }

    public boolean containsNull() {
        return this.value == null;
    }

    public boolean isEmpty() {
        return this.type == Type.EMPTY;
    }

    public boolean isIgnored() {
        return this.type == Type.IGNORED;
    }

    public boolean isDelayed() {
        return this.type == Type.DELAYED;
    }

    public String toString() {
        if (this.type == Type.NORMAL) {
            return String.format("Result[%s, %s]", this.value, this.hints);
        }
        return String.format("Result[%s]", new Object[]{this.type});
    }

    private static enum Type {
        NULL,
        EMPTY,
        IGNORED,
        DELAYED,
        NORMAL;

    }
}

