/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.internet;

import java.util.Locale;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.EmailAsGeneratorSpec;
import org.instancio.generator.specs.EmailSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.specs.InternalLengthGeneratorSpec;
import org.instancio.support.Global;

public class EmailGenerator
extends AbstractGenerator<String>
implements EmailSpec,
EmailAsGeneratorSpec,
InternalLengthGeneratorSpec<String> {
    private static final String[] TLDS = new String[]{"com", "edu", "net", "org"};
    private int minLength = 7;
    private int maxLength = 24;

    public EmailGenerator() {
        super(Global.generatorContext());
    }

    public EmailGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "email()";
    }

    @Override
    public EmailGenerator nullable() {
        super.nullable();
        return this;
    }

    public EmailGenerator nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    @Override
    public EmailGenerator length(int min, int max) {
        ApiValidator.isTrue(min >= 3, "email length must be at least 3 characters long", new Object[0]);
        ApiValidator.isTrue(min <= max, "email length min must be less than or equal to max: (%s, %s)", min, max);
        this.minLength = min;
        this.maxLength = max;
        return this;
    }

    @Override
    public EmailGenerator length(int length) {
        this.length(length, length);
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        int len = random.intRange(this.minLength, this.maxLength);
        if (len >= 7) {
            String tld = "." + random.oneOf(TLDS);
            int rem = len - tld.length() - 1;
            return EmailGenerator.emailWithoutTld(random, rem) + tld;
        }
        int rem = len - 1;
        return EmailGenerator.emailWithoutTld(random, rem);
    }

    private static String emailWithoutTld(Random random, int length) {
        int localPartLen = random.intRange(1, length - 1);
        int domainLen = length - localPartLen;
        String localPart = random.alphanumeric(localPartLen).toLowerCase(Locale.ROOT);
        String domain = random.alphanumeric(domainLen).toLowerCase(Locale.ROOT);
        return localPart + '@' + domain;
    }
}

