/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.misc;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.instancio.Random;
import org.instancio.exception.InstancioException;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.specs.EmitGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.util.CollectionUtils;

public class EmitGenerator<T>
extends AbstractGenerator<T>
implements EmitGeneratorSpec<T> {
    private final Queue<T> items = new LinkedList<T>();
    private boolean shuffle;
    private boolean ignoreUnused;
    private WhenEmptyAction whenEmptyAction = WhenEmptyAction.EMIT_RANDOM;

    public EmitGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return null;
    }

    @Override
    public EmitGenerator<T> items(T ... items) {
        ApiValidator.notNull(items, "'items' array must not be null", new Object[0]);
        Collections.addAll(this.items, items);
        return this;
    }

    @Override
    public EmitGeneratorSpec<T> items(Iterable<? extends T> items) {
        ApiValidator.notNull(items, "'items' Iterable must not be null", new Object[0]);
        for (T item : items) {
            this.items.add(item);
        }
        return this;
    }

    @Override
    public EmitGenerator<T> item(T item, int n) {
        ApiValidator.isTrue(n >= 0, "Number of items must not be negative: " + n, new Object[0]);
        for (int i = 0; i < n; ++i) {
            this.items.add(item);
        }
        return this;
    }

    @Override
    public EmitGenerator<T> shuffle() {
        this.shuffle = true;
        return this;
    }

    @Override
    public EmitGenerator<T> ignoreUnused() {
        this.ignoreUnused = true;
        return this;
    }

    @Override
    public EmitGenerator<T> whenEmptyEmitNull() {
        this.whenEmptyAction = WhenEmptyAction.EMIT_NULL;
        return this;
    }

    @Override
    public EmitGenerator<T> whenEmptyEmitRandom() {
        this.whenEmptyAction = WhenEmptyAction.EMIT_RANDOM;
        return this;
    }

    @Override
    public EmitGenerator<T> whenEmptyThrowException() {
        this.whenEmptyAction = WhenEmptyAction.FAIL;
        return this;
    }

    public WhenEmptyAction getWhenEmptyAction() {
        return this.whenEmptyAction;
    }

    public boolean hasMore() {
        return !this.items.isEmpty();
    }

    public Collection<T> getItems() {
        return this.items;
    }

    public boolean isIgnoreUnused() {
        return this.ignoreUnused;
    }

    @Override
    protected T tryGenerateNonNull(Random random) {
        if (this.items.isEmpty()) {
            throw new InstancioException("Invalid call to emit() - no items available");
        }
        if (this.shuffle) {
            CollectionUtils.shuffle(this.items, random);
            this.shuffle = false;
        }
        return this.items.poll();
    }

    @Override
    public Hints hints() {
        return Hints.builder().afterGenerate(AfterGenerate.DO_NOT_MODIFY).with(InternalGeneratorHint.builder().emitNull(this.whenEmptyAction == WhenEmptyAction.EMIT_NULL).build()).build();
    }

    public static enum WhenEmptyAction {
        EMIT_NULL,
        EMIT_RANDOM,
        FAIL;

    }
}

