/*
 * Decompiled with CFR 0.152.
 */
package org.instancio;

import java.util.Objects;
import java.util.function.Predicate;
import org.instancio.documentation.ExperimentalApi;

@ExperimentalApi
public final class When {
    @ExperimentalApi
    public static <T> Predicate<T> is(T value) {
        return v -> Objects.equals(v, value);
    }

    @ExperimentalApi
    public static <T> Predicate<T> isNot(T value) {
        return v -> !Objects.equals(v, value);
    }

    @ExperimentalApi
    public static <T> Predicate<T> isNull() {
        return Objects::isNull;
    }

    @ExperimentalApi
    public static <T> Predicate<T> isNotNull() {
        return Objects::nonNull;
    }

    @SafeVarargs
    @ExperimentalApi
    public static <T> Predicate<T> isIn(T ... values) {
        return value -> {
            for (Object v : values) {
                if (!Objects.equals(v, value)) continue;
                return true;
            }
            return false;
        };
    }

    private When() {
    }
}

