/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Hint;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.util.ObjectUtils;

public final class Hints {
    private final AfterGenerate afterGenerate;
    private final Map<Class<?>, Object> hintMap;

    private Hints(Builder builder) {
        this.afterGenerate = builder.afterGenerate;
        this.hintMap = ObjectUtils.defaultIfNull(builder.hintMap, Collections.emptyMap());
    }

    public static Hints afterGenerate(AfterGenerate afterGenerate) {
        return Hints.builder().afterGenerate(afterGenerate).build();
    }

    public static Builder builder(Hints copy) {
        Builder builder = new Builder();
        builder.afterGenerate = copy.afterGenerate;
        builder.hintMap = copy.hintMap;
        return builder;
    }

    public AfterGenerate afterGenerate() {
        return this.afterGenerate;
    }

    public <T extends Hint<T>> T get(Class<T> hintType) {
        ApiValidator.notNull(hintType, "Hint type must not be null", new Object[0]);
        return (T)((Hint)hintType.cast(this.hintMap.get(hintType)));
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return new StringJoiner(", ", "Hints[", "]").add("afterGenerate=" + (Object)((Object)this.afterGenerate)).add("hints=" + this.hintMap).toString();
    }

    public static final class Builder {
        private AfterGenerate afterGenerate;
        private Map<Class<?>, Object> hintMap;

        private Builder() {
        }

        public <T extends Hint<T>> Builder with(T hint) {
            ApiValidator.notNull(hint, "Hint must not be null", new Object[0]);
            if (this.hintMap == null) {
                this.hintMap = new HashMap();
            }
            this.hintMap.put(hint.type(), hint);
            return this;
        }

        public Builder afterGenerate(AfterGenerate afterGenerate) {
            this.afterGenerate = ApiValidator.notNull(afterGenerate, "AfterGenerate must not be null", new Object[0]);
            return this;
        }

        public Hints build() {
            return new Hints(this);
        }
    }
}

