/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assigners;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.instancio.exception.InstancioApiException;
import org.instancio.exception.InstancioException;
import org.instancio.internal.assigners.Assigner;
import org.instancio.internal.assigners.AssignerUtil;
import org.instancio.internal.assigners.DefaultSetterMethodResolver;
import org.instancio.internal.assigners.FieldAssigner;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeImpl;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.ExceptionUtils;
import org.instancio.internal.util.Format;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.Keys;
import org.instancio.settings.OnSetMethodError;
import org.instancio.settings.OnSetMethodNotFound;
import org.instancio.settings.Settings;
import org.instancio.spi.InstancioServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MethodAssigner
implements Assigner {
    private static final Logger LOG = LoggerFactory.getLogger(MethodAssigner.class);
    private final Settings settings;
    private final int excludedModifiers;
    private final Assigner fieldAssigner;
    private final DefaultSetterMethodResolver defaultSetterMethodResolver;
    private final List<ProviderEntry<InstancioServiceProvider.SetterMethodResolver>> setterMethodResolvers;

    MethodAssigner(Settings settings, List<ProviderEntry<InstancioServiceProvider.SetterMethodResolver>> spiResolvers) {
        this.settings = settings;
        this.excludedModifiers = settings.get(Keys.SETTER_EXCLUDE_MODIFIER);
        this.fieldAssigner = new FieldAssigner(settings);
        this.defaultSetterMethodResolver = new DefaultSetterMethodResolver(settings);
        this.setterMethodResolvers = spiResolvers;
        LOG.trace("{}, {}, {}, {}", new Object[]{AssignmentType.METHOD, settings.get(Keys.SETTER_STYLE), settings.get(Keys.ON_SET_METHOD_NOT_FOUND), settings.get(Keys.ON_SET_METHOD_ERROR)});
    }

    @Override
    public void assign(InternalNode node, Object target, Object arg) {
        Field field = node.getField();
        if (arg != null) {
            if (Modifier.isFinal(field.getModifiers())) {
                this.fieldAssigner.assign(node, target, arg);
            } else {
                this.assignViaMethod(node, target, arg);
            }
        } else if (!field.getType().isPrimitive()) {
            this.assignViaMethod(node, target, null);
        }
    }

    private void assignViaMethod(InternalNode internalNode, Object target, Object arg) {
        Method method = this.resolveSetterMethod(internalNode);
        if (method != null) {
            if (AssignerUtil.isExcluded(method.getModifiers(), this.excludedModifiers)) {
                return;
            }
            try {
                method.setAccessible(true);
                method.invoke(target, arg);
            }
            catch (IllegalAccessException ex) {
                throw new InstancioException("Error setting value via method: " + method, ex);
            }
            catch (Exception ex) {
                this.handleMethodInvocationError(internalNode, target, arg, method, ex);
            }
        } else {
            this.handleMethodNotFoundError(internalNode, target, arg);
        }
    }

    private Method resolveSetterMethod(InternalNode internalNode) {
        NodeImpl node = new NodeImpl(internalNode.getTargetClass(), internalNode.getField());
        for (ProviderEntry<InstancioServiceProvider.SetterMethodResolver> entry : this.setterMethodResolvers) {
            Method method = entry.getProvider().getSetter(node);
            if (method == null) continue;
            return method;
        }
        return this.defaultSetterMethodResolver.getSetter(internalNode);
    }

    private void handleMethodInvocationError(InternalNode node, Object target, Object arg, Method method, Exception ex) {
        OnSetMethodError onSetMethodError = this.settings.get(Keys.ON_SET_METHOD_ERROR);
        if (onSetMethodError == OnSetMethodError.FAIL) {
            String methodName = Format.formatMethod(method);
            String errorMsg = ErrorMessageUtils.getSetterInvocationErrorMessage(arg, methodName, ex, this.settings);
            throw new InstancioApiException(errorMsg, ex);
        }
        if (onSetMethodError == OnSetMethodError.ASSIGN_FIELD) {
            ExceptionUtils.logException("Error invoking method {}, assigning value using field: {}", ex, method, node.getField());
            this.fieldAssigner.assign(node, target, arg);
        } else if (onSetMethodError == OnSetMethodError.IGNORE) {
            ExceptionUtils.logException("{}: error invoking method: {}", ex, new Object[]{OnSetMethodError.IGNORE, method});
        }
    }

    private void handleMethodNotFoundError(InternalNode node, Object target, Object arg) {
        OnSetMethodNotFound onSetMethodNotFound = this.settings.get(Keys.ON_SET_METHOD_NOT_FOUND);
        if (onSetMethodNotFound == OnSetMethodNotFound.FAIL) {
            throw new InstancioApiException(ErrorMessageUtils.setterNotFound(node, this.settings));
        }
        if (onSetMethodNotFound == OnSetMethodNotFound.ASSIGN_FIELD) {
            LOG.trace("Could not resolve setter method, assigning value using field: {}", (Object)node.getField());
            this.fieldAssigner.assign(node, target, arg);
        } else if (onSetMethodNotFound == OnSetMethodNotFound.IGNORE) {
            LOG.debug("{}: could not resolve setter method for field: {}", (Object)OnSetMethodNotFound.IGNORE, (Object)node.getField());
        }
    }
}

