/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.hash;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.HashAsGeneratorSpec;
import org.instancio.generator.specs.HashSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.lang.StringGenerator;
import org.instancio.support.Global;

public class HashGenerator
extends AbstractGenerator<String>
implements HashSpec,
HashAsGeneratorSpec {
    private final StringGenerator delegate;
    private Type type = Type.MD5;

    public HashGenerator() {
        this(Global.generatorContext());
    }

    public HashGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new StringGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "hash()";
    }

    @Override
    public HashGenerator md5() {
        this.type = Type.MD5;
        return this;
    }

    @Override
    public HashGenerator sha1() {
        this.type = Type.SHA1;
        return this;
    }

    @Override
    public HashGenerator sha256() {
        this.type = Type.SHA256;
        return this;
    }

    @Override
    public HashGenerator sha512() {
        this.type = Type.SHA512;
        return this;
    }

    @Override
    public HashGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        return this.delegate.hex().length(this.type.length).tryGenerateNonNull(random);
    }

    private static enum Type {
        MD5(32),
        SHA1(40),
        SHA256(64),
        SHA512(128);

        private final int length;

        private Type(int length) {
            this.length = length;
        }
    }
}

