/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.util.List;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Format;

public final class NodeStats {
    private static final int SB_SIZE = 10000;
    private static final int NUM_NODES = 0;
    private static final int MAX_DEPTH = 1;
    private final String treeString;
    private final int totalNodes;
    private final int height;

    private NodeStats(String treeString, int totalNodes, int height) {
        this.treeString = treeString;
        this.totalNodes = totalNodes;
        this.height = height;
    }

    public static NodeStats compute(InternalNode rootNode) {
        int[] stats = new int[2];
        stats[0] = 1;
        StringBuilder sb = new StringBuilder(10000);
        sb.append(Format.formatAsTreeNode(rootNode)).append(Constants.NL);
        NodeStats.appendTreeLine(rootNode, sb, stats, "");
        return new NodeStats(sb.toString(), stats[0], stats[1]);
    }

    private static void appendTreeLine(InternalNode node, StringBuilder sb, int[] stats, String prefix) {
        List<InternalNode> children = node.getChildren();
        int size = children.size();
        stats[0] = stats[0] + size;
        stats[1] = Math.max(stats[1], node.getDepth());
        for (int i = 0; i < size; ++i) {
            InternalNode n = children.get(i);
            if (i == size - 1) {
                sb.append(prefix).append(" \u2514\u2500\u2500").append(Format.formatAsTreeNode(n)).append(Constants.NL);
                NodeStats.appendTreeLine(n, sb, stats, prefix + "    ");
                continue;
            }
            sb.append(prefix).append(" \u251c\u2500\u2500").append(Format.formatAsTreeNode(n)).append(Constants.NL);
            NodeStats.appendTreeLine(n, sb, stats, prefix + " \u2502  ");
        }
    }

    public String getTreeString() {
        return this.treeString;
    }

    public int getTotalNodes() {
        return this.totalNodes;
    }

    public int getHeight() {
        return this.height;
    }
}

