/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.function.Predicate;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.nodes.InternalNode;

final class SelectorDepth {
    private final Integer depth;
    private final Predicate<InternalNode> depthPredicate;

    SelectorDepth(int depth) {
        this.depth = ApiValidator.validateDepth(depth);
        this.depthPredicate = SelectorDepth.toNodePredicate(d -> d == depth);
    }

    SelectorDepth(Predicate<Integer> depthPredicate) {
        ApiValidator.notNull(depthPredicate, "Selector depth predicate must not be null", new Object[0]);
        this.depth = null;
        this.depthPredicate = SelectorDepth.toNodePredicate(depthPredicate);
    }

    private static Predicate<InternalNode> toNodePredicate(Predicate<Integer> p) {
        return n -> p.test(n.getDepth());
    }

    Integer getDepth() {
        return this.depth;
    }

    Predicate<InternalNode> getDepthPredicate() {
        return this.depthPredicate;
    }
}

