/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.instancio.internal.util.Verify;

public final class IOUtils {
    private IOUtils() {
    }

    public static void writeTo(Path path, InputStream inputStream) throws IOException {
        Verify.notNull(inputStream, "Input stream is null", new Object[0]);
        try (InputStream in = inputStream;
             OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            int read;
            byte[] buf = new byte[512];
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
    }
}

