/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.generator.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.instancio.generator.Hint;
import org.instancio.internal.ApiValidator;

public final class MapHint
implements Hint<MapHint> {
    private static final MapHint EMPTY_HINT = MapHint.builder().build();
    private final int generateEntries;
    private final boolean nullableMapKeys;
    private final boolean nullableMapValues;
    private final Map<?, ?> withEntries;
    private final List<?> withKeys;

    private MapHint(Builder builder) {
        this.generateEntries = builder.generateEntries;
        this.nullableMapKeys = builder.nullableMapKeys;
        this.nullableMapValues = builder.nullableMapValues;
        this.withEntries = builder.withEntries == null ? Collections.emptyMap() : Collections.unmodifiableMap(builder.withEntries);
        this.withKeys = builder.withKeys == null ? Collections.emptyList() : Collections.unmodifiableList(builder.withKeys);
    }

    public static MapHint empty() {
        return EMPTY_HINT;
    }

    public int generateEntries() {
        return this.generateEntries;
    }

    public boolean nullableMapKeys() {
        return this.nullableMapKeys;
    }

    public boolean nullableMapValues() {
        return this.nullableMapValues;
    }

    public <K, V> Map<K, V> withEntries() {
        return this.withEntries;
    }

    public <K> List<K> withKeys() {
        return this.withKeys;
    }

    public String toString() {
        return new StringJoiner(", ", "MapHint[", "]").add("generateEntries=" + this.generateEntries).add("nullableMapKeys=" + this.nullableMapKeys).add("nullableMapValues=" + this.nullableMapValues).add("withEntries=" + this.withEntries).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int generateEntries;
        private boolean nullableMapKeys;
        private boolean nullableMapValues;
        private Map<Object, Object> withEntries;
        private List<Object> withKeys;

        private Builder() {
        }

        public Builder generateEntries(int generateEntries) {
            ApiValidator.isTrue(generateEntries >= 0, "Data structure size must not be negative", new Object[0]);
            this.generateEntries = generateEntries;
            return this;
        }

        public Builder nullableMapKeys(boolean nullableMapKeys) {
            this.nullableMapKeys = nullableMapKeys;
            return this;
        }

        public Builder nullableMapValues(boolean nullableMapValues) {
            this.nullableMapValues = nullableMapValues;
            return this;
        }

        public <K, V> Builder withEntries(Map<? extends K, ? extends V> entries) {
            if (entries == null) {
                return this;
            }
            if (this.withEntries == null) {
                this.withEntries = new HashMap<Object, Object>();
            }
            this.withEntries.putAll(entries);
            return this;
        }

        public <K> Builder withKeys(List<? extends K> keys) {
            if (keys == null) {
                return this;
            }
            if (this.withKeys == null) {
                this.withKeys = new ArrayList<Object>();
            }
            this.withKeys.addAll(keys);
            return this;
        }

        public MapHint build() {
            return new MapHint(this);
        }
    }
}

