/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.instancio.internal.DelayedNode;
import org.instancio.internal.nodes.InternalNode;
import org.jetbrains.annotations.NotNull;

public final class DelayedNodeQueue
implements Iterable<DelayedNode> {
    private final Deque<DelayedNode> delayedNodes = new ArrayDeque<DelayedNode>();
    private final Set<InternalNode> delayedRecordNodes = new HashSet<InternalNode>();

    void addLast(DelayedNode delayedNode) {
        this.delayedNodes.addLast(delayedNode);
    }

    DelayedNode removeFirst() {
        return this.delayedNodes.removeFirst();
    }

    void addRecord(InternalNode node) {
        this.delayedRecordNodes.add(node);
    }

    void removeRecord(InternalNode node) {
        this.delayedRecordNodes.remove(node);
    }

    int size() {
        return this.delayedNodes.size();
    }

    boolean isEmpty() {
        return this.delayedNodes.isEmpty();
    }

    boolean hasRecordNodes() {
        return !this.delayedRecordNodes.isEmpty();
    }

    public Stream<DelayedNode> stream() {
        return this.delayedNodes.stream();
    }

    @Override
    @NotNull
    public Iterator<DelayedNode> iterator() {
        return this.delayedNodes.iterator();
    }
}

