/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import org.instancio.Random;
import org.instancio.documentation.InternalApi;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.support.DefaultRandom;
import org.instancio.support.Global;
import org.instancio.support.Seeds;
import org.instancio.support.ThreadLocalRandom;
import org.jetbrains.annotations.Nullable;

@InternalApi
public final class RandomHelper {
    public static Random resolveRandom(@Nullable Long settingsSeed, @Nullable Long withSeed) {
        if (withSeed != null) {
            return new DefaultRandom(withSeed);
        }
        Random configuredRandom = Global.getConfiguredRandom();
        if (settingsSeed != null && (configuredRandom == null || configuredRandom.getSeed() != settingsSeed.longValue())) {
            return new DefaultRandom(settingsSeed);
        }
        if (ThreadLocalRandom.getInstance().get() != null) {
            return ThreadLocalRandom.getInstance().get();
        }
        return ObjectUtils.defaultIfNull(configuredRandom, () -> new DefaultRandom(Seeds.randomSeed()));
    }

    private RandomHelper() {
    }
}

