/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.math;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.BigDecimalAsGeneratorSpec;
import org.instancio.generator.specs.BigDecimalSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.lang.AbstractRandomComparableNumberGeneratorSpec;
import org.instancio.settings.Keys;
import org.instancio.support.Global;

public class BigDecimalGenerator
extends AbstractRandomComparableNumberGeneratorSpec<BigDecimal>
implements BigDecimalSpec,
BigDecimalAsGeneratorSpec {
    private static final BigDecimal DEFAULT_MIN = new BigDecimal("0.01");
    private static final BigDecimal DEFAULT_MAX = new BigDecimal("10000.00");
    private int scale;
    private int precision;

    public BigDecimalGenerator() {
        this(Global.generatorContext());
    }

    public BigDecimalGenerator(GeneratorContext context) {
        this(context, DEFAULT_MIN, DEFAULT_MAX, false);
    }

    public BigDecimalGenerator(GeneratorContext context, BigDecimal min, BigDecimal max, boolean nullable) {
        super(context, min, max, nullable);
        this.scale = context.getSettings().get(Keys.BIG_DECIMAL_SCALE);
    }

    @Override
    public String apiMethod() {
        return "bigDecimal()";
    }

    @Override
    public BigDecimalGenerator scale(int scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public BigDecimalGenerator precision(int precision) {
        ApiValidator.isTrue(precision > 0, "'precision' must be positive: %s", precision);
        this.precision = precision;
        return this;
    }

    @Override
    public BigDecimalGenerator min(BigDecimal min) {
        super.min(min);
        this.unsetPrecision();
        return this;
    }

    @Override
    public BigDecimalGenerator max(BigDecimal max) {
        super.max(max);
        this.unsetPrecision();
        return this;
    }

    @Override
    public BigDecimalGenerator range(BigDecimal min, BigDecimal max) {
        super.range(min, max);
        this.unsetPrecision();
        return this;
    }

    @Override
    public BigDecimalGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    public BigDecimalGenerator nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    private void unsetPrecision() {
        this.precision = 0;
    }

    @Override
    protected BigDecimal tryGenerateNonNull(Random random) {
        if (this.precision == 0) {
            BigDecimal delta = ((BigDecimal)this.getMax()).subtract((BigDecimal)this.getMin());
            BigDecimal rndDelta = delta.multiply(BigDecimal.valueOf(random.doubleRange(0.01, 1.0)));
            return ((BigDecimal)this.getMin()).add(rndDelta).setScale(this.scale, RoundingMode.HALF_UP);
        }
        char[] result = this.scale == 0 ? this.generateInteger(random) : (this.scale < 0 ? this.generateWithNegativeScale(random) : (this.precision == this.scale ? this.generateWithEqualPrecisionAndScale(random) : (this.precision > this.scale ? this.generateFractionalWithPrecisionGreaterThanScale(random) : this.generateWithPrecisionLessThanScale(random))));
        return new BigDecimal(new String(result), new MathContext(this.precision, RoundingMode.UNNECESSARY));
    }

    private char[] generateFractionalWithPrecisionGreaterThanScale(Random random) {
        char[] digits = new char[this.precision + 1];
        int i = 0;
        digits[i++] = BigDecimalGenerator.oneToNine(random);
        while (i < this.precision - this.scale) {
            digits[i++] = BigDecimalGenerator.zeroToNine(random);
        }
        digits[i++] = 46;
        while (i < digits.length) {
            digits[i++] = BigDecimalGenerator.zeroToNine(random);
        }
        return digits;
    }

    private char[] generateWithEqualPrecisionAndScale(Random random) {
        char[] digits = new char[1 + this.scale];
        int i = 0;
        digits[i++] = 46;
        digits[i++] = BigDecimalGenerator.oneToNine(random);
        while (i < digits.length) {
            digits[i++] = BigDecimalGenerator.zeroToNine(random);
        }
        return digits;
    }

    private char[] generateWithNegativeScale(Random random) {
        char[] digits = new char[this.precision + Math.abs(this.scale)];
        int i = 0;
        digits[i++] = BigDecimalGenerator.oneToNine(random);
        while (i < this.precision) {
            digits[i++] = BigDecimalGenerator.zeroToNine(random);
        }
        while (i < digits.length) {
            digits[i++] = 48;
        }
        return digits;
    }

    private char[] generateInteger(Random random) {
        char[] digits = new char[this.precision];
        int i = 0;
        digits[i++] = BigDecimalGenerator.oneToNine(random);
        while (i < digits.length) {
            digits[i++] = BigDecimalGenerator.zeroToNine(random);
        }
        return digits;
    }

    private char[] generateWithPrecisionLessThanScale(Random random) {
        char[] digits = new char[this.scale + 1];
        int i = 0;
        digits[i++] = 46;
        while (i <= this.scale - this.precision) {
            digits[i++] = 48;
        }
        while (i < digits.length) {
            digits[i++] = BigDecimalGenerator.oneToNine(random);
        }
        return digits;
    }

    private static char zeroToNine(Random random) {
        return random.characterRange('0', '9');
    }

    private static char oneToNine(Random random) {
        return random.characterRange('1', '9');
    }
}

