/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.sql;

import java.sql.Timestamp;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.TemporalGeneratorSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.time.InstantGenerator;

public class TimestampGenerator
extends AbstractGenerator<Timestamp>
implements TemporalGeneratorSpec<Timestamp> {
    private final InstantGenerator delegate;

    public TimestampGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new InstantGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "timestamp()";
    }

    public TimestampGenerator past() {
        this.delegate.past();
        return this;
    }

    public TimestampGenerator future() {
        this.delegate.future();
        return this;
    }

    public TimestampGenerator range(Timestamp start, Timestamp end) {
        this.delegate.range(start.toInstant(), end.toInstant());
        return this;
    }

    @Override
    public TimestampGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    public Timestamp tryGenerateNonNull(Random random) {
        return Timestamp.from(this.delegate.tryGenerateNonNull(random));
    }
}

