/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.instancio.DepthPredicateSelector;
import org.instancio.GroupableSelector;
import org.instancio.PredicateSelector;
import org.instancio.TargetSelector;
import org.instancio.internal.Flattener;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.selectors.SelectorDepth;
import org.instancio.internal.selectors.UnusedSelectorDescription;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.Verify;

public class PredicateSelectorImpl
implements PredicateSelector,
DepthPredicateSelector,
Flattener<TargetSelector>,
UnusedSelectorDescription {
    private static final int FIELD_PRIORITY = 1;
    private static final int TYPE_PRIORITY = 2;
    private static final String DEFAULT_SELECTOR_DESCRIPTION = "<selector>";
    private static final Predicate<Field> NON_NULL_FIELD = Objects::nonNull;
    private static final Predicate<Class<?>> NON_NULL_TYPE = Objects::nonNull;
    private final int priority;
    private final Predicate<InternalNode> nodePredicate;
    private final SelectorDepth selectorDepth;
    private final String apiInvocationDescription;
    private final Throwable stackTraceHolder;

    protected PredicateSelectorImpl(int priority, Predicate<InternalNode> nodePredicate, SelectorDepth selectorDepth, String apiInvocationDescription, Throwable stackTraceHolder) {
        this.priority = priority;
        this.nodePredicate = nodePredicate;
        this.selectorDepth = selectorDepth;
        this.apiInvocationDescription = apiInvocationDescription;
        this.stackTraceHolder = stackTraceHolder;
    }

    private PredicateSelectorImpl(Builder builder) {
        this(builder.priority, builder.nodePredicate, builder.selectorDepth, ObjectUtils.defaultIfNull(builder.apiInvocationDescription, DEFAULT_SELECTOR_DESCRIPTION), ObjectUtils.defaultIfNull(builder.stackTraceHolder, Throwable::new));
    }

    @Override
    public List<TargetSelector> flatten() {
        return Collections.singletonList(this);
    }

    @Override
    public String getDescription() {
        return String.format("%s%n    at %s", this, Format.firstNonInstancioStackTraceLine(this.stackTraceHolder));
    }

    public int getPriority() {
        return this.priority;
    }

    public Predicate<InternalNode> getNodePredicate() {
        return this.nodePredicate;
    }

    @Override
    public GroupableSelector atDepth(int depth) {
        return PredicateSelectorImpl.builder(this).depth(depth).build();
    }

    @Override
    public GroupableSelector atDepth(Predicate<Integer> depthPredicate) {
        return PredicateSelectorImpl.builder(this).depth(depthPredicate).build();
    }

    public String toString() {
        String s = this.apiInvocationDescription;
        if (this.selectorDepth != null) {
            String depth = this.selectorDepth.getDepth() == null ? "Predicate<Integer>" : this.selectorDepth.getDepth().toString();
            s = s + ".atDepth(" + depth + ")";
        }
        return s;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PredicateSelectorImpl copy) {
        Builder builder = new Builder();
        builder.priority = copy.priority;
        builder.nodePredicate = copy.nodePredicate;
        builder.apiInvocationDescription = copy.apiInvocationDescription;
        builder.stackTraceHolder = copy.stackTraceHolder;
        builder.selectorDepth = copy.selectorDepth;
        return builder;
    }

    public static final class Builder {
        private int priority;
        private Predicate<InternalNode> nodePredicate = Objects::nonNull;
        private SelectorDepth selectorDepth;
        private String apiInvocationDescription;
        private Throwable stackTraceHolder;

        private Builder() {
        }

        public Builder fieldPredicate(Predicate<Field> predicate) {
            this.priority = 1;
            this.nodePredicate = this.nodePredicate.and(node -> NON_NULL_FIELD.and(predicate).test(node.getField()));
            if (this.apiInvocationDescription == null) {
                this.apiInvocationDescription = "fields(Predicate<Field>)";
            }
            return this;
        }

        public Builder typePredicate(Predicate<Class<?>> predicate) {
            this.priority = 2;
            this.nodePredicate = this.nodePredicate.and(node -> NON_NULL_TYPE.and(predicate).test(node.getTargetClass()));
            if (this.apiInvocationDescription == null) {
                this.apiInvocationDescription = "types(Predicate<Class>)";
            }
            return this;
        }

        Builder depth(int depth) {
            return this.withDepth(new SelectorDepth(depth));
        }

        Builder depth(Predicate<Integer> predicate) {
            return this.withDepth(new SelectorDepth(predicate));
        }

        private Builder withDepth(SelectorDepth selectorDepth) {
            Verify.state(this.selectorDepth == null, "depth already set!", new Object[0]);
            this.selectorDepth = selectorDepth;
            this.nodePredicate = this.nodePredicate.and(selectorDepth.getDepthPredicate());
            return this;
        }

        public Builder apiInvocationDescription(String apiInvocationDescription) {
            this.apiInvocationDescription = apiInvocationDescription;
            return this;
        }

        public Builder stackTraceHolder(Throwable stackTraceHolder) {
            this.stackTraceHolder = stackTraceHolder;
            return this;
        }

        public PredicateSelectorImpl build() {
            return new PredicateSelectorImpl(this);
        }
    }
}

