/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.annotation.Annotation;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.UniqueElements;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.specs.CollectionGeneratorSpec;
import org.instancio.generator.specs.DurationGeneratorSpec;
import org.instancio.generator.specs.NumberGeneratorSpec;
import org.instancio.generator.specs.StringGeneratorSpec;
import org.instancio.internal.annotation.AnnotationHandlerMap;
import org.instancio.internal.annotation.AnnotationUtils;
import org.instancio.internal.annotation.FieldAnnotationHandler;
import org.instancio.internal.generator.lang.AbstractRandomNumberGeneratorSpec;
import org.instancio.internal.generator.lang.LongGenerator;
import org.instancio.internal.generator.lang.StringGenerator;
import org.instancio.internal.generator.specs.InternalLengthGeneratorSpec;
import org.instancio.internal.util.NumberUtils;
import org.instancio.internal.util.Range;
import org.instancio.settings.Keys;

final class HibernateBeanValidationHandlerMap
extends AnnotationHandlerMap {
    HibernateBeanValidationHandlerMap() {
        this.put(() -> DurationMin.class, new DurationMinHandler());
        this.put(() -> DurationMax.class, new DurationMaxHandler());
        this.put(() -> Length.class, new LengthHandler());
        this.put(() -> org.hibernate.validator.constraints.Range.class, new RangeHandler());
        this.put(() -> UniqueElements.class, new UniqueElementsHandler());
    }

    static AnnotationHandlerMap getInstance() {
        return Holder.INSTANCE;
    }

    private static final class DurationMinHandler
    implements FieldAnnotationHandler {
        private DurationMinHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Class<?> targetClass) {
            if (spec instanceof DurationGeneratorSpec) {
                DurationMin d = (DurationMin)annotation;
                Duration min = Duration.ofDays(d.days()).plusHours(d.hours()).plusMinutes(d.minutes()).plusSeconds(d.seconds()).plusMillis(d.millis()).plusNanos(d.nanos());
                DurationGeneratorSpec durationSpec = (DurationGeneratorSpec)spec;
                durationSpec.min(min.toNanos(), ChronoUnit.NANOS);
            }
        }
    }

    private static final class DurationMaxHandler
    implements FieldAnnotationHandler {
        private DurationMaxHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Class<?> targetClass) {
            if (spec instanceof DurationGeneratorSpec) {
                DurationMax d = (DurationMax)annotation;
                Duration max = Duration.ofDays(d.days()).plusHours(d.hours()).plusMinutes(d.minutes()).plusSeconds(d.seconds()).plusMillis(d.millis()).plusNanos(d.nanos());
                DurationGeneratorSpec durationSpec = (DurationGeneratorSpec)spec;
                durationSpec.max(max.toNanos(), ChronoUnit.NANOS);
            }
        }
    }

    private static final class LengthHandler
    implements FieldAnnotationHandler {
        private LengthHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Class<?> targetClass) {
            Length length = (Length)annotation;
            Range<Integer> range = AnnotationUtils.calculateRange(length.min(), length.max(), Keys.STRING_MAX_LENGTH.defaultValue());
            if (spec instanceof InternalLengthGeneratorSpec) {
                ((InternalLengthGeneratorSpec)spec).length(range.min(), range.max());
            }
            if (range.min() > 0 && spec instanceof StringGeneratorSpec) {
                ((StringGeneratorSpec)spec).allowEmpty(false);
            }
        }
    }

    private static final class RangeHandler
    implements FieldAnnotationHandler {
        private RangeHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Class<?> targetClass) {
            org.hibernate.validator.constraints.Range range = (org.hibernate.validator.constraints.Range)annotation;
            if (spec instanceof NumberGeneratorSpec) {
                Function<Long, Long> fromLongConverter = NumberUtils.longConverter(targetClass);
                AbstractRandomNumberGeneratorSpec numSpec = (AbstractRandomNumberGeneratorSpec)spec;
                numSpec.min((Number)fromLongConverter.apply(range.min())).max((Number)fromLongConverter.apply(range.max()));
                AnnotationUtils.setSpecNullableToFalse(spec);
            } else if (spec instanceof StringGenerator) {
                StringGenerator stringGenerator = (StringGenerator)spec;
                LongGenerator numGenerator = new LongGenerator(stringGenerator.getContext()).nullable(false).min(range.min()).max(range.max());
                stringGenerator.setDelegate(numGenerator);
            }
        }
    }

    private static final class UniqueElementsHandler
    implements FieldAnnotationHandler {
        private UniqueElementsHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Class<?> targetClass) {
            if (spec instanceof CollectionGeneratorSpec) {
                ((CollectionGeneratorSpec)spec).unique();
            }
        }
    }

    private static final class Holder {
        private static final AnnotationHandlerMap INSTANCE = new HibernateBeanValidationHandlerMap();

        private Holder() {
        }
    }
}

