/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assigners;

import org.instancio.internal.assigners.Assigner;
import org.instancio.internal.assigners.FieldAssigner;
import org.instancio.internal.assigners.MethodAssigner;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Fail;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;

public class AssignerImpl
implements Assigner {
    private final Assigner delegate;

    public AssignerImpl(ModelContext<?> context) {
        this.delegate = AssignerImpl.resolveAssigner(context);
    }

    @Override
    public void assign(InternalNode node, Object target, Object value) {
        this.delegate.assign(node, target, value);
    }

    private static Assigner resolveAssigner(ModelContext<?> context) {
        Settings settings = context.getSettings();
        AssignmentType assignment = settings.get(Keys.ASSIGNMENT_TYPE);
        if (assignment == AssignmentType.FIELD) {
            return new FieldAssigner(settings);
        }
        if (assignment == AssignmentType.METHOD) {
            return new MethodAssigner(context);
        }
        throw Fail.withFataInternalError("Invalid assignment type: %s", new Object[]{assignment});
    }
}

