/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assignment;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.instancio.Assignment;
import org.instancio.GeneratorSpecProvider;
import org.instancio.GivenOriginDestinationAction;
import org.instancio.TargetSelector;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.Flattener;
import org.instancio.internal.assignment.GeneratorHolder;
import org.instancio.internal.assignment.InternalAssignment;

public class InternalGivenOriginDestinationAction
implements GivenOriginDestinationAction,
Flattener<InternalAssignment> {
    private final List<InternalAssignment> assignments = new ArrayList<InternalAssignment>(3);
    private final TargetSelector origin;
    private final TargetSelector destination;

    public InternalGivenOriginDestinationAction(TargetSelector origin, TargetSelector destination) {
        this.origin = origin;
        this.destination = destination;
    }

    @Override
    public <S, T> GivenOriginDestinationAction generate(Predicate<S> predicate, GeneratorSpecProvider<T> gen) {
        return this.add(predicate, GeneratorHolder.of(gen));
    }

    @Override
    public <S, T> GivenOriginDestinationAction generate(Predicate<S> predicate, GeneratorSpec<T> spec) {
        return this.add(predicate, GeneratorHolder.of(spec));
    }

    @Override
    public <S, T> GivenOriginDestinationAction set(Predicate<S> predicate, T value) {
        return this.add(predicate, GeneratorHolder.of(value));
    }

    @Override
    public <S, T> GivenOriginDestinationAction supply(Predicate<S> predicate, Generator<T> generator) {
        return this.add(predicate, GeneratorHolder.of(generator));
    }

    @Override
    public <S, T> GivenOriginDestinationAction supply(Predicate<S> predicate, Supplier<T> supplier) {
        return this.add(predicate, GeneratorHolder.of(supplier));
    }

    @Override
    public <T> Assignment elseGenerate(GeneratorSpecProvider<T> gen) {
        return this.add(this.negatePredicates(), GeneratorHolder.of(gen));
    }

    @Override
    public <T> Assignment elseGenerate(GeneratorSpec<T> spec) {
        return this.add(this.negatePredicates(), GeneratorHolder.of(spec));
    }

    @Override
    public <T> Assignment elseSet(T value) {
        return this.add(this.negatePredicates(), GeneratorHolder.of(value));
    }

    @Override
    public <T> Assignment elseSupply(Generator<T> generator) {
        return this.add(this.negatePredicates(), GeneratorHolder.of(generator));
    }

    @Override
    public <T> Assignment elseSupply(Supplier<T> supplier) {
        return this.add(this.negatePredicates(), GeneratorHolder.of(supplier));
    }

    @Override
    public List<InternalAssignment> flatten() {
        return this.assignments;
    }

    private <T> Predicate<T> negatePredicates() {
        Predicate<Object> predicate = v -> false;
        for (InternalAssignment assignment : this.assignments) {
            predicate = predicate.or(assignment.getOriginPredicate());
        }
        return predicate.negate();
    }

    private <S> GivenOriginDestinationAction add(Predicate<S> predicate, GeneratorHolder generatorHolder) {
        this.assignments.add(InternalAssignment.builder().origin(this.origin).originPredicate(predicate).destination(this.destination).generatorHolder(generatorHolder).build());
        return this;
    }
}

