/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import java.util.Arrays;
import java.util.EnumSet;
import org.instancio.Random;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.specs.EnumAsGeneratorSpec;
import org.instancio.generator.specs.EnumSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.support.Global;

public class EnumGenerator<E extends Enum<E>>
extends AbstractGenerator<E>
implements EnumSpec<E>,
EnumAsGeneratorSpec<E> {
    private final Class<E> enumClass;
    private final EnumSet<E> values;
    private EnumSet<E> valuesWithExclusions;

    public EnumGenerator(Class<E> enumClass) {
        this(Global.generatorContext(), enumClass);
    }

    public EnumGenerator(GeneratorContext context, Class<E> enumClass) {
        super(context);
        this.enumClass = ApiValidator.notNull(enumClass, "enum class must not be null");
        this.values = EnumSet.allOf(enumClass);
        this.valuesWithExclusions = EnumSet.noneOf(enumClass);
    }

    @Override
    public String apiMethod() {
        return "enumOf()";
    }

    @Override
    @SafeVarargs
    public final EnumGenerator<E> excluding(E ... values) {
        ApiValidator.notNull(values, "excluded values must not be null: excluding()");
        if (values.length > 0) {
            EnumSet<E> exclusions = EnumSet.copyOf(Arrays.asList(values));
            this.valuesWithExclusions = EnumSet.complementOf(exclusions);
        }
        return this;
    }

    @Override
    public EnumGenerator<E> nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected E tryGenerateNonNull(Random random) {
        if (this.values.isEmpty()) {
            return null;
        }
        return (E)(this.valuesWithExclusions.isEmpty() ? (Enum)random.oneOf(this.values) : (Enum)random.oneOf(this.valuesWithExclusions));
    }

    @Override
    public Hints hints() {
        return Hints.builder().afterGenerate(AfterGenerate.DO_NOT_MODIFY).with(InternalGeneratorHint.builder().targetClass(this.enumClass).build()).build();
    }
}

