/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.instantiation;

import java.lang.reflect.Constructor;
import org.instancio.internal.instantiation.InstantiationStrategy;
import org.instancio.internal.instantiation.InstantiationStrategyException;
import org.instancio.internal.util.ReflectionUtils;

class NoArgumentConstructorInstantiationStrategy
implements InstantiationStrategy {
    NoArgumentConstructorInstantiationStrategy() {
    }

    @Override
    public <T> T createInstance(Class<T> klass) {
        try {
            Constructor<?> ctor = NoArgumentConstructorInstantiationStrategy.getDefaultConstructor(klass);
            if (ctor == null) {
                return null;
            }
            ReflectionUtils.setAccessible(ctor);
            return (T)ctor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new InstantiationStrategyException("Error instantiating " + klass, ex);
        }
    }

    private static Constructor<?> getDefaultConstructor(Class<?> klass) {
        for (Constructor<?> ctor : klass.getDeclaredConstructors()) {
            if (ctor.getParameterCount() != 0) continue;
            return ctor;
        }
        return null;
    }
}

