/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.instancio.Scope;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.ObjectUtils;

public final class Format {
    private static final int SB_SMALL = 60;
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("\\w+\\.");

    public static String formatNode(InternalNode node) {
        return node.getField() == null ? Format.withoutPackage(node.getType()) : Format.formatField(node.getField());
    }

    public static String nodePathToRootBlock(InternalNode node) {
        return node.toDisplayString() + " (depth=" + node.getDepth() + ')' + Constants.NL + Constants.NL + " \u2502 Path to root:" + Constants.NL + Format.nodePathToRoot(node, " \u2502   ") + "   <-- Root" + Constants.NL + " \u2502" + Constants.NL + " \u2502 Format: <depth:class: field>";
    }

    public static String nodePathToRoot(InternalNode node, String prefix) {
        String padding = "";
        StringBuilder sb = new StringBuilder(prefix).append(Format.formatAsTreeNode(node));
        for (InternalNode n = node.getParent(); n != null; n = n.getParent()) {
            sb.append(Constants.NL).append(prefix).append(padding).append(" \u2514\u2500\u2500").append(Format.formatAsTreeNode(n));
            padding = padding + "    ";
        }
        return sb.toString();
    }

    public static String formatAsTreeNode(InternalNode node) {
        StringBuilder sb = new StringBuilder(60);
        sb.append('<').append(node.getDepth()).append(':');
        if (node.getField() == null && node.getSetter() == null) {
            sb.append(Format.withoutPackage(node.getTargetClass()));
        } else {
            sb.append(Format.withoutPackage(node.getParent().getTargetClass())).append(": ");
            if (node.getField() != null) {
                sb.append(Format.withoutPackage(node.getType())).append(' ').append(node.getField().getName());
            }
            if (node.getSetter() != null) {
                if (node.getField() != null) {
                    sb.append("; ");
                }
                Type paramType = node.getSetter().getGenericParameterTypes()[0];
                sb.append(node.getSetter().getName()).append('(').append(Format.withoutPackage(paramType)).append(')');
            }
        }
        if (node.isIgnored()) {
            sb.append(" [IGNORED]");
        }
        if (node.isCyclic()) {
            sb.append(" [CYCLIC]");
        }
        return sb.append('>').toString();
    }

    public static String formatField(Field field) {
        return field == null ? null : String.format("%s %s (in %s)", Format.withoutPackage(ObjectUtils.defaultIfNull(field.getGenericType(), field.getType())), field.getName(), field.getDeclaringClass().getName());
    }

    public static String formatSetterMethod(Method method) {
        return method == null ? null : String.format("%s.%s(%s)", Format.withoutPackage(method.getDeclaringClass()), method.getName(), Format.withoutPackage(method.getParameterTypes()[0]));
    }

    public static String methodNameWithParams(Method method) {
        String params = Arrays.stream(method.getParameterTypes()).map(Format::withoutPackage).collect(Collectors.joining(", "));
        return String.format("%s(%s)", method.getName(), params);
    }

    public static String withoutPackage(Type type) {
        return PACKAGE_PATTERN.matcher(type.getTypeName()).replaceAll("");
    }

    public static String formatScopes(List<Scope> scopes) {
        return scopes.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    public static String getTypeVariablesCsv(Class<?> klass) {
        return Arrays.stream(klass.getTypeParameters()).map(TypeVariable::getName).collect(Collectors.joining(", "));
    }

    public static String firstNonInstancioStackTraceLine(Throwable throwable) {
        for (StackTraceElement element : throwable.getStackTrace()) {
            String className = element.getClassName();
            if (className.startsWith("org.instancio") || className.startsWith("java.")) continue;
            return element.toString();
        }
        return "<unknown location>";
    }

    private Format() {
    }
}

