/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit;

import java.lang.reflect.Method;
import java.util.Optional;
import org.instancio.internal.ThreadLocalRandom;
import org.instancio.internal.ThreadLocalSettings;
import org.instancio.junit.ExtensionSupport;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancioExtension
implements BeforeEachCallback,
AfterEachCallback,
AfterTestExecutionCallback {
    private static final Logger LOG = LoggerFactory.getLogger(InstancioExtension.class);
    private final ThreadLocalRandom threadLocalRandom;
    private final ThreadLocalSettings threadLocalSettings;

    public InstancioExtension() {
        this.threadLocalRandom = ThreadLocalRandom.getInstance();
        this.threadLocalSettings = ThreadLocalSettings.getInstance();
    }

    InstancioExtension(ThreadLocalRandom threadLocalRandom, ThreadLocalSettings threadLocalSettings) {
        this.threadLocalRandom = threadLocalRandom;
        this.threadLocalSettings = threadLocalSettings;
    }

    public void beforeEach(ExtensionContext context) {
        ExtensionSupport.processAnnotations(context, this.threadLocalRandom, this.threadLocalSettings);
    }

    public void afterEach(ExtensionContext context) {
        this.threadLocalRandom.remove();
        this.threadLocalSettings.remove();
    }

    public void afterTestExecution(ExtensionContext context) {
        if (context.getExecutionException().isPresent()) {
            Optional testMethod = context.getTestMethod();
            if (!testMethod.isPresent()) {
                return;
            }
            long seed = this.threadLocalRandom.get().getSeed();
            String msg = String.format("Test method '%s' failed with seed: %d%n", ((Method)testMethod.get()).getName(), seed);
            context.publishReportEntry("Instancio", msg);
            LOG.debug(msg);
        }
    }
}

