/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.itsallcode.holidays.calculator.logic.parser.HolidayParser;
import org.itsallcode.holidays.calculator.logic.variants.Holiday;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolidaysFileParser {
    private static final Logger LOG = LoggerFactory.getLogger(HolidaysFileParser.class);
    private static final String COMMENT_CHAR = "#";
    private final HolidayParser holidayParser = new HolidayParser();
    private final List<Error> errors = new ArrayList<Error>();
    private final String identifier;

    public HolidaysFileParser(String inputSourceIdentifier) {
        this.identifier = inputSourceIdentifier;
    }

    public List<Holiday> parse(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        ArrayList<Holiday> result = new ArrayList<Holiday>();
        int n = 0;
        while ((line = reader.readLine()) != null) {
            ++n;
            if ((line = this.cutOffComment(line)).isEmpty()) continue;
            Holiday holiday = this.holidayParser.parse(line);
            if (holiday != null) {
                result.add(holiday);
                continue;
            }
            LOG.error("File {}:{}: Couldn't parse '{}'.", new Object[]{this.identifier, n, line});
            this.errors.add(new Error(n, line));
        }
        return result;
    }

    private String cutOffComment(String string) {
        return string.replaceFirst("#.*$", "").trim();
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public static class Error {
        public final int lineNumber;
        public final String content;

        public Error(int lineNumber, String content) {
            this.lineNumber = lineNumber;
            this.content = content;
        }
    }
}

