/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.parser.matcher;

import java.time.MonthDay;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.itsallcode.holidays.calculator.logic.conditions.builder.ConditionBuilder;
import org.itsallcode.holidays.calculator.logic.parser.matcher.HolidayMatcher;
import org.itsallcode.holidays.calculator.logic.parser.matcher.Patterns;
import org.itsallcode.holidays.calculator.logic.variants.ConditionalHoliday;
import org.itsallcode.holidays.calculator.logic.variants.FixedDateHoliday;
import org.itsallcode.holidays.calculator.logic.variants.Holiday;
import org.itsallcode.holidays.calculator.logic.variants.HolidayWithAlternative;

class FixedDateMatcher
extends HolidayMatcher {
    FixedDateMatcher() {
        super(Patterns.FIXED_HOLIDAY);
    }

    @Override
    FixedDateHoliday createHoliday(Matcher matcher) {
        return new FixedDateHoliday(matcher.group("category"), matcher.group("name"), this.monthDay(matcher.group("month"), matcher.group("day")));
    }

    static class Alternative
    extends HolidayMatcher {
        private final boolean negated;

        Alternative(Pattern pattern) {
            super(new FixedDateMatcher(), pattern);
            this.negated = pattern == Patterns.ALTERNATIVE_DATE_HOLIDAY_NEGATED_DAY_OF_WEEK;
        }

        @Override
        Holiday createHoliday(Matcher matcher) {
            MonthDay alternateDate = this.monthDay(matcher.group("month2"), matcher.group("day2"));
            ConditionBuilder conditionBuilder = this.createConditionBuilder(matcher);
            return new HolidayWithAlternative(this.createOriginalHoliday(matcher), this.negated ? conditionBuilder.negated() : conditionBuilder, alternateDate);
        }
    }

    static class Conditional
    extends HolidayMatcher {
        Conditional() {
            super(new FixedDateMatcher(), Patterns.CONDITIONAL_FIXED_HOLIDAY);
        }

        @Override
        Holiday createHoliday(Matcher matcher) {
            return new ConditionalHoliday(this.createConditionBuilder(matcher), this.createOriginalHoliday(matcher));
        }
    }
}

