/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.variants;

import java.time.LocalDate;
import java.time.Year;
import java.util.Objects;
import org.itsallcode.holidays.calculator.logic.conditions.Condition;
import org.itsallcode.holidays.calculator.logic.conditions.builder.ConditionBuilder;
import org.itsallcode.holidays.calculator.logic.variants.Holiday;

public class ConditionalHoliday
extends Holiday {
    private final Condition condition;
    private final Holiday other;

    public ConditionalHoliday(ConditionBuilder conditionBuilder, Holiday holiday) {
        super(holiday.getCategory(), holiday.getName());
        this.condition = conditionBuilder.build();
        this.other = holiday;
    }

    @Override
    public LocalDate of(int year) {
        if (!this.condition.applies(Year.of(year))) {
            return null;
        }
        return this.other.of(year);
    }

    @Override
    public String toString() {
        return this.other.toString(this.condition.toString(" only "));
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.condition, this.other);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionalHoliday otherHoliday = (ConditionalHoliday)obj;
        return Objects.equals(this.condition, otherHoliday.condition) && Objects.equals(this.other, otherHoliday.other);
    }
}

