/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.variants;

import java.time.LocalDate;
import java.time.MonthDay;
import java.util.Objects;
import org.itsallcode.holidays.calculator.logic.Formatter;
import org.itsallcode.holidays.calculator.logic.variants.Holiday;

public class FixedDateHoliday
extends Holiday {
    private final MonthDay monthDay;

    public FixedDateHoliday(String category, String name, MonthDay monthDay) {
        super(category, name);
        this.monthDay = monthDay;
    }

    public FixedDateHoliday(Holiday other, MonthDay monthDay) {
        super(other.getCategory(), other.getName());
        this.monthDay = monthDay;
    }

    @Override
    public LocalDate of(int year) {
        return this.monthDay.atYear(year);
    }

    @Override
    public String toString(Holiday pivot) {
        if (pivot instanceof FixedDateHoliday && pivot.getName().equals(this.getName()) && pivot.getCategory().equals(this.getCategory())) {
            return Formatter.format(this.monthDay);
        }
        return this.toString();
    }

    @Override
    public String toString(String condition) {
        return String.format("%s(%s %s: %s%s)", this.getClass().getSimpleName(), this.getCategory(), this.getName(), Formatter.format(this.monthDay), condition);
    }

    @Override
    public MonthDay getMonthDay() {
        return this.monthDay;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.monthDay);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedDateHoliday other = (FixedDateHoliday)obj;
        return Objects.equals(this.monthDay, other.monthDay);
    }
}

