/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.commands;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacoco.cli.internal.Command;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.data.ExecutionDataStore;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class ClassInfo
extends Command {
    @Argument(usage="location of Java class files", metaVar="<classlocations>")
    List<File> classfiles = new ArrayList<File>();
    @Option(name="--verbose", usage="show method and line number details")
    boolean verbose = false;

    public String description() {
        return "Print information about Java class files at the provided location.";
    }

    public int execute(PrintWriter out, PrintWriter err) throws IOException {
        if (this.classfiles.isEmpty()) {
            out.println("[WARN] No class files provided.");
        } else {
            Analyzer analyzer = new Analyzer(new ExecutionDataStore(), (ICoverageVisitor)new Printer(out));
            for (File file : this.classfiles) {
                analyzer.analyzeAll(file);
            }
        }
        return 0;
    }

    private class Printer
    implements ICoverageVisitor {
        private final PrintWriter out;

        Printer(PrintWriter out) {
            this.out = out;
            out.println("  INST   BRAN   LINE   METH   CXTY   ELEMENT");
        }

        public void visitCoverage(IClassCoverage coverage) {
            String desc = String.format("class 0x%016x %s", coverage.getId(), coverage.getName());
            this.printDetails(desc, (ICoverageNode)coverage);
            if (ClassInfo.this.verbose) {
                Iterator i = coverage.getMethods().iterator();
                while (i.hasNext()) {
                    this.printMethod((IMethodCoverage)i.next(), i.hasNext());
                }
            }
        }

        private void printMethod(IMethodCoverage method, boolean more) {
            String desc = String.format("+- method %s%s", method.getName(), method.getDesc());
            this.printDetails(desc, (ICoverageNode)method);
            for (int nr = method.getFirstLine(); nr <= method.getLastLine(); ++nr) {
                this.printLine(method.getLine(nr), nr, more ? "| " : "  ");
            }
        }

        private void printLine(ILine line, int nr, String indent) {
            if (line.getStatus() != 0) {
                this.out.printf("%6s %6s                        %s +- line %s%n", this.total(line.getInstructionCounter()), this.total(line.getBranchCounter()), indent, nr);
            }
        }

        private void printDetails(String description, ICoverageNode coverage) {
            this.out.printf("%6s %6s %6s %6s %6s   %s%n", this.total(coverage.getInstructionCounter()), this.total(coverage.getBranchCounter()), this.total(coverage.getLineCounter()), this.total(coverage.getMethodCounter()), this.total(coverage.getComplexityCounter()), description);
        }

        private String total(ICounter counter) {
            return String.valueOf(counter.getTotalCount());
        }
    }
}

