/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal.flow;

import java.util.HashMap;
import java.util.Map;
import org.jacoco.cli.internal.asm.Label;
import org.jacoco.cli.internal.asm.MethodVisitor;
import org.jacoco.cli.internal.asm.commons.AnalyzerAdapter;
import org.jacoco.cli.internal.core.internal.flow.FrameSnapshot;
import org.jacoco.cli.internal.core.internal.flow.IFrame;
import org.jacoco.cli.internal.core.internal.flow.IProbeIdGenerator;
import org.jacoco.cli.internal.core.internal.flow.LabelInfo;
import org.jacoco.cli.internal.core.internal.flow.MethodProbesVisitor;

public final class MethodProbesAdapter
extends MethodVisitor {
    private final MethodProbesVisitor probesVisitor;
    private final IProbeIdGenerator idGenerator;
    private AnalyzerAdapter analyzer;
    private final Map<Label, Label> tryCatchProbeLabels;

    public MethodProbesAdapter(MethodProbesVisitor probesVisitor, IProbeIdGenerator idGenerator) {
        super(458752, probesVisitor);
        this.probesVisitor = probesVisitor;
        this.idGenerator = idGenerator;
        this.tryCatchProbeLabels = new HashMap<Label, Label>();
    }

    public void setAnalyzer(AnalyzerAdapter analyzer) {
        this.analyzer = analyzer;
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.probesVisitor.visitTryCatchBlock(this.getTryCatchLabel(start), this.getTryCatchLabel(end), handler, type);
    }

    private Label getTryCatchLabel(Label label) {
        if (this.tryCatchProbeLabels.containsKey(label)) {
            label = this.tryCatchProbeLabels.get(label);
        } else if (LabelInfo.needsProbe(label)) {
            Label probeLabel = new Label();
            LabelInfo.setSuccessor(probeLabel);
            this.tryCatchProbeLabels.put(label, probeLabel);
            label = probeLabel;
        }
        return label;
    }

    public void visitLabel(Label label) {
        if (LabelInfo.needsProbe(label)) {
            if (this.tryCatchProbeLabels.containsKey(label)) {
                this.probesVisitor.visitLabel(this.tryCatchProbeLabels.get(label));
            }
            this.probesVisitor.visitProbe(this.idGenerator.nextId());
        }
        this.probesVisitor.visitLabel(label);
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.probesVisitor.visitInsnWithProbe(opcode, this.idGenerator.nextId());
                break;
            }
            default: {
                this.probesVisitor.visitInsn(opcode);
            }
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (LabelInfo.isMultiTarget(label)) {
            this.probesVisitor.visitJumpInsnWithProbe(opcode, label, this.idGenerator.nextId(), this.frame(this.jumpPopCount(opcode)));
        } else {
            this.probesVisitor.visitJumpInsn(opcode, label);
        }
    }

    private int jumpPopCount(int opcode) {
        switch (opcode) {
            case 167: {
                return 0;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                return 1;
            }
        }
        return 2;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (this.markLabels(dflt, labels)) {
            this.probesVisitor.visitLookupSwitchInsnWithProbes(dflt, keys, labels, this.frame(1));
        } else {
            this.probesVisitor.visitLookupSwitchInsn(dflt, keys, labels);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        if (this.markLabels(dflt, labels)) {
            this.probesVisitor.visitTableSwitchInsnWithProbes(min, max, dflt, labels, this.frame(1));
        } else {
            this.probesVisitor.visitTableSwitchInsn(min, max, dflt, labels);
        }
    }

    private boolean markLabels(Label dflt, Label[] labels) {
        boolean probe = false;
        LabelInfo.resetDone(labels);
        if (LabelInfo.isMultiTarget(dflt)) {
            LabelInfo.setProbeId(dflt, this.idGenerator.nextId());
            probe = true;
        }
        LabelInfo.setDone(dflt);
        for (Label l : labels) {
            if (LabelInfo.isMultiTarget(l) && !LabelInfo.isDone(l)) {
                LabelInfo.setProbeId(l, this.idGenerator.nextId());
                probe = true;
            }
            LabelInfo.setDone(l);
        }
        return probe;
    }

    private IFrame frame(int popCount) {
        return FrameSnapshot.create(this.analyzer, popCount);
    }
}

