/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jamon.api.Location;
import org.jamon.codegen.CallStatement;
import org.jamon.codegen.ChildCallStatement;
import org.jamon.codegen.ComponentCallStatement;
import org.jamon.codegen.DefCallStatement;
import org.jamon.codegen.DefUnit;
import org.jamon.codegen.EscapingDirective;
import org.jamon.codegen.FargCallStatement;
import org.jamon.codegen.FlowControlBlock;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.InheritedUnit;
import org.jamon.codegen.LiteralStatement;
import org.jamon.codegen.MethodCallStatement;
import org.jamon.codegen.MethodUnit;
import org.jamon.codegen.NamedParamValues;
import org.jamon.codegen.ParamValues;
import org.jamon.codegen.PathAdapter;
import org.jamon.codegen.RawStatement;
import org.jamon.codegen.Statement;
import org.jamon.codegen.StatementBlock;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.TemplateUnit;
import org.jamon.codegen.UnnamedParamValues;
import org.jamon.codegen.WriteStatement;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.emit.EmitMode;
import org.jamon.node.AbsMethodNode;
import org.jamon.node.AbstractComponentCallNode;
import org.jamon.node.AbstractEscapeNode;
import org.jamon.node.AbstractNode;
import org.jamon.node.AbstractParamsNode;
import org.jamon.node.AbstractPathNode;
import org.jamon.node.AliasDefNode;
import org.jamon.node.AliasesNode;
import org.jamon.node.AnalysisAdapter;
import org.jamon.node.AnnotationNode;
import org.jamon.node.ArgNode;
import org.jamon.node.ChildCallNode;
import org.jamon.node.ClassNode;
import org.jamon.node.DefNode;
import org.jamon.node.DefaultEscapeNode;
import org.jamon.node.DepthFirstAnalysisAdapter;
import org.jamon.node.ElseIfNode;
import org.jamon.node.ElseNode;
import org.jamon.node.EmitNode;
import org.jamon.node.EscapeDirectiveNode;
import org.jamon.node.EscapeNode;
import org.jamon.node.ExtendsNode;
import org.jamon.node.ForNode;
import org.jamon.node.FragmentArgsNode;
import org.jamon.node.FragmentCallNode;
import org.jamon.node.GenericCallParam;
import org.jamon.node.GenericsParamNode;
import org.jamon.node.IfNode;
import org.jamon.node.ImplementNode;
import org.jamon.node.ImportNode;
import org.jamon.node.JavaNode;
import org.jamon.node.LiteralNode;
import org.jamon.node.MethodNode;
import org.jamon.node.MultiFragmentCallNode;
import org.jamon.node.NamedFragmentNode;
import org.jamon.node.NamedParamNode;
import org.jamon.node.NamedParamsNode;
import org.jamon.node.OptionalArgNode;
import org.jamon.node.OverrideNode;
import org.jamon.node.ParamValueNode;
import org.jamon.node.ParentArgNode;
import org.jamon.node.ParentArgWithDefaultNode;
import org.jamon.node.ParentArgsNode;
import org.jamon.node.ParentMarkerNode;
import org.jamon.node.SimpleCallNode;
import org.jamon.node.StaticImportNode;
import org.jamon.node.TextNode;
import org.jamon.node.TopNode;
import org.jamon.node.UnnamedParamsNode;
import org.jamon.node.WhileNode;
import org.jamon.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer {
    private final TemplateUnit m_templateUnit;
    private StatementBlock m_currentStatementBlock;
    private final TemplateDescriber m_describer;
    private final Set<String> m_children;
    private final LinkedList<CallStatement> m_callStatements = new LinkedList();
    private final Map<String, String> m_aliases = new HashMap<String, String>();
    private final String m_templateDir;
    private final String m_templateIdentifier;
    private final EmitMode m_emitMode;
    private ParserErrorsImpl m_errors = new ParserErrorsImpl();
    private EscapingDirective m_defaultEscaping;

    public Analyzer(String p_templatePath, TemplateDescriber p_describer, Set<String> p_children) throws IOException {
        this.m_templateUnit = new TemplateUnit(p_templatePath, this.m_errors);
        this.m_templateDir = p_templatePath.substring(0, 1 + p_templatePath.lastIndexOf(47));
        this.m_currentStatementBlock = this.m_templateUnit;
        this.m_describer = p_describer;
        this.m_children = p_children;
        this.m_emitMode = p_describer.getEmitMode(p_templatePath);
        this.m_templateIdentifier = this.m_describer.getExternalIdentifier(p_templatePath);
        this.m_templateUnit.setJamonContextType(p_describer.getJamonContextType(p_templatePath));
        this.m_aliases.putAll(this.m_describer.getAliases(p_templatePath));
    }

    public Analyzer(String p_templatePath, TemplateDescriber p_describer) throws IOException {
        this(p_templatePath, p_describer, new HashSet<String>());
    }

    public TemplateUnit analyze() throws IOException {
        TopNode top = this.m_describer.parseTemplate(this.m_templateUnit.getName());
        this.preAnalyze(top);
        this.mainAnalyze(top);
        this.checkForConcreteness(top);
        if (this.m_errors.hasErrors()) {
            throw this.m_errors;
        }
        return this.m_templateUnit;
    }

    private void addError(String p_message, Location p_location) {
        this.m_errors.addError(new ParserErrorImpl(p_location, p_message));
    }

    private void preAnalyze(TopNode p_top) throws IOException {
        this.topLevelAnalyze(p_top, new AliasAdapter());
        this.topLevelAnalyze(p_top, new PreliminaryAdapter());
        if (this.m_defaultEscaping == null) {
            this.m_defaultEscaping = this.m_describer.getEscaping(this.m_templateUnit.getName());
        }
        if (this.m_defaultEscaping == null) {
            this.m_defaultEscaping = EscapingDirective.get("h");
        }
    }

    private void topLevelAnalyze(TopNode p_top, AnalysisAdapter p_adapter) {
        for (AbstractNode node : p_top.getSubNodes()) {
            node.apply(p_adapter);
        }
    }

    private void mainAnalyze(TopNode p_top) {
        p_top.apply(new Adapter());
    }

    public void checkForConcreteness(TopNode p_top) {
        if (!this.getTemplateUnit().isParent() && !this.getTemplateUnit().getAbstractMethodNames().isEmpty()) {
            this.topLevelAnalyze(p_top, new AnalysisAdapter(){

                public void caseExtendsNode(ExtendsNode p_extends) {
                    StringBuilder message = new StringBuilder("The abstract method(s) ");
                    StringUtils.commaJoin(message, Analyzer.this.getTemplateUnit().getAbstractMethodNames());
                    message.append(" have no concrete implementation");
                    Analyzer.this.addError(message.toString(), p_extends.getLocation());
                }
            });
        }
    }

    private void pushDefUnit(String p_defName) {
        this.m_currentStatementBlock = this.getTemplateUnit().getDefUnit(p_defName);
    }

    private void pushMethodUnit(String p_methodName) {
        this.m_currentStatementBlock = this.getTemplateUnit().getMethodUnit(p_methodName);
    }

    private void pushOverriddenMethodUnit(OverrideNode p_node) {
        this.m_currentStatementBlock = this.getTemplateUnit().makeOverridenMethodUnit(p_node.getName(), p_node.getLocation());
    }

    private void pushFlowControlBlock(Location p_location, String p_header) {
        FlowControlBlock flowControlBlock = new FlowControlBlock(this.m_currentStatementBlock, p_header, p_location);
        this.addStatement(flowControlBlock);
        this.m_currentStatementBlock = flowControlBlock;
    }

    private FragmentUnit pushFragmentUnitImpl(String p_fragName, Location p_location) {
        this.m_currentStatementBlock = new FragmentUnit(p_fragName, this.getCurrentStatementBlock(), this.getTemplateUnit().getGenericParams(), this.m_errors, p_location);
        return (FragmentUnit)this.m_currentStatementBlock;
    }

    private void pushFragmentArg(FragmentUnit p_frag) {
        this.m_currentStatementBlock = p_frag;
    }

    private void popStatementBlock() {
        this.m_currentStatementBlock = this.m_currentStatementBlock.getParent();
    }

    private void pushCallStatement(CallStatement p_callStatement) {
        this.m_callStatements.add(p_callStatement);
    }

    private void popCallStatement() {
        this.m_callStatements.removeLast();
    }

    private CallStatement getCurrentCallStatement() {
        return this.m_callStatements.getLast();
    }

    private TemplateUnit getTemplateUnit() {
        return this.m_templateUnit;
    }

    private StatementBlock getCurrentStatementBlock() {
        return this.m_currentStatementBlock;
    }

    private String getAbsolutePath(String p_path) {
        return p_path.charAt(0) == '/' ? p_path : this.m_templateDir + p_path;
    }

    private String computePath(AbstractPathNode p_path) {
        PathAdapter adapter = new PathAdapter(this.m_templateDir, this.m_aliases, this.m_errors);
        p_path.apply(adapter);
        return adapter.getPath();
    }

    private EscapingDirective getDefaultEscaping() {
        return this.m_defaultEscaping;
    }

    private CallStatement makeCallStatement(AbstractComponentCallNode p_node) {
        String path = this.computePath(p_node.getCallPath());
        ParamValues paramValues = this.makeParamValues(p_node.getParams());
        FragmentUnit fragmentUnit = this.getCurrentStatementBlock().getFragmentUnitIntf(path);
        List<GenericCallParam> genericParams = p_node.getGenericParams();
        if (fragmentUnit != null) {
            if (!genericParams.isEmpty()) {
                this.addError("Fragment calls may not have generic params", p_node.getLocation());
            }
            return new FargCallStatement(path, paramValues, fragmentUnit, p_node.getLocation(), this.m_templateIdentifier);
        }
        DefUnit defUnit = this.getTemplateUnit().getDefUnit(path);
        if (defUnit != null) {
            if (!genericParams.isEmpty()) {
                this.addError("def " + defUnit.getName() + " is being called with generic parameters", p_node.getLocation());
            }
            return new DefCallStatement(path, paramValues, defUnit, p_node.getLocation(), this.m_templateIdentifier);
        }
        MethodUnit methodUnit = this.getTemplateUnit().getMethodUnit(path);
        if (methodUnit != null) {
            if (!genericParams.isEmpty()) {
                this.addError("method" + methodUnit.getName() + " is being called with generic parameters", p_node.getLocation());
            }
            return new MethodCallStatement(path, paramValues, methodUnit, p_node.getLocation(), this.m_templateIdentifier);
        }
        this.getTemplateUnit().addCallPath(this.getAbsolutePath(path));
        return new ComponentCallStatement(this.getAbsolutePath(path), paramValues, p_node.getLocation(), this.m_templateIdentifier, genericParams, this.getTemplateUnit().getJamonContextType());
    }

    private ParamValues makeParamValues(AbstractParamsNode p_params) {
        return new ParamsAdapter().getParamValues(p_params);
    }

    private void addStatement(Statement p_statement) {
        this.getCurrentStatementBlock().addStatement(p_statement);
    }

    private static class ParamsAdapter
    extends DepthFirstAnalysisAdapter {
        private Map<String, String> m_paramsMap = null;
        private List<String> m_paramsList = null;

        private ParamsAdapter() {
        }

        public ParamValues getParamValues(AbstractParamsNode p_node) {
            p_node.apply(this);
            if (this.m_paramsList != null) {
                return new UnnamedParamValues(this.m_paramsList, p_node.getLocation());
            }
            return new NamedParamValues(this.m_paramsMap, p_node.getLocation());
        }

        public void inNamedParamsNode(NamedParamsNode p_node) {
            this.m_paramsMap = new HashMap<String, String>();
        }

        public void inUnnamedParamsNode(UnnamedParamsNode p_node) {
            this.m_paramsList = new LinkedList<String>();
        }

        public void caseNamedParamNode(NamedParamNode p_node) {
            this.m_paramsMap.put(p_node.getName().getName(), p_node.getValue().getValue());
        }

        public void caseParamValueNode(ParamValueNode p_node) {
            this.m_paramsList.add(p_node.getValue());
        }
    }

    private class Adapter
    extends DepthFirstAnalysisAdapter {
        private Adapter() {
        }

        public void caseImportNode(ImportNode p_import) {
            Analyzer.this.getTemplateUnit().addImport(p_import);
        }

        public void caseStaticImportNode(StaticImportNode p_import) {
            Analyzer.this.getTemplateUnit().addStaticImport(p_import);
        }

        public void caseImplementNode(ImplementNode p_node) {
            Analyzer.this.getTemplateUnit().addInterface(p_node.getName());
        }

        public void caseParentArgsNode(ParentArgsNode p_node) {
            if (Analyzer.this.getCurrentStatementBlock() instanceof TemplateUnit && !((TemplateUnit)Analyzer.this.getCurrentStatementBlock()).hasParentPath()) {
                Analyzer.this.addError("xargs may not be declared without extending another template", p_node.getLocation());
            } else {
                super.caseParentArgsNode(p_node);
            }
        }

        public void caseParentArgNode(ParentArgNode p_node) {
            ((InheritedUnit)((Object)Analyzer.this.getCurrentStatementBlock())).addParentArg(p_node);
        }

        public void caseParentArgWithDefaultNode(ParentArgWithDefaultNode p_node) {
            ((InheritedUnit)((Object)Analyzer.this.getCurrentStatementBlock())).addParentArg(p_node);
        }

        public void inFragmentArgsNode(FragmentArgsNode p_node) {
            Analyzer.this.pushFragmentArg(Analyzer.this.getCurrentStatementBlock().addFragment(p_node, Analyzer.this.getTemplateUnit().getGenericParams()));
        }

        public void outFragmentArgsNode(FragmentArgsNode p_node) {
            Analyzer.this.popStatementBlock();
        }

        public void caseArgNode(ArgNode p_node) {
            Analyzer.this.getCurrentStatementBlock().addRequiredArg(p_node);
        }

        public void caseOptionalArgNode(OptionalArgNode p_node) {
            Analyzer.this.getCurrentStatementBlock().addOptionalArg(p_node);
        }

        public void inDefNode(DefNode p_node) {
            Analyzer.this.pushDefUnit(p_node.getName());
        }

        public void outDefNode(DefNode p_def) {
            Analyzer.this.popStatementBlock();
        }

        public void inMethodNode(MethodNode p_node) {
            Analyzer.this.pushMethodUnit(p_node.getName());
        }

        public void outMethodNode(MethodNode p_node) {
            Analyzer.this.popStatementBlock();
        }

        public void inAbsMethodNode(AbsMethodNode p_node) {
            if (!Analyzer.this.getTemplateUnit().isParent()) {
                Analyzer.this.addError("Non-abstract templates cannot have abstract methods", p_node.getLocation());
            }
            Analyzer.this.pushMethodUnit(p_node.getName());
        }

        public void outAbsMethodNode(AbsMethodNode p_node) {
            Analyzer.this.popStatementBlock();
        }

        public void inOverrideNode(OverrideNode p_node) {
            Analyzer.this.pushOverriddenMethodUnit(p_node);
        }

        public void outOverrideNode(OverrideNode p_node) {
            Analyzer.this.popStatementBlock();
        }

        public void caseGenericsParamNode(GenericsParamNode p_node) {
            if (Analyzer.this.m_templateUnit.isParent()) {
                Analyzer.this.addError("<%generics> tag not allowed in abstract templates", p_node.getLocation());
            }
            Analyzer.this.m_templateUnit.addGenericsParamNode(p_node);
        }

        public void caseSimpleCallNode(SimpleCallNode p_node) {
            Analyzer.this.addStatement(Analyzer.this.makeCallStatement(p_node));
        }

        public void caseChildCallNode(ChildCallNode p_node) {
            TemplateUnit unit = Analyzer.this.getTemplateUnit();
            if (!unit.isParent()) {
                Analyzer.this.addError("<& *CHILD &> cannot be called from a template without an <%abstract> tag", p_node.getLocation());
            }
            Analyzer.this.addStatement(new ChildCallStatement(unit.getInheritanceDepth() + 1));
        }

        public void caseClassNode(ClassNode p_node) {
            Analyzer.this.getTemplateUnit().addClassContent(p_node);
        }

        public void caseTextNode(TextNode p_node) {
            Analyzer.this.addStatement(new LiteralStatement(p_node.getText(), p_node.getLocation(), Analyzer.this.m_templateIdentifier));
        }

        public void caseLiteralNode(LiteralNode p_node) {
            Analyzer.this.addStatement(new LiteralStatement(p_node.getText(), p_node.getLocation(), Analyzer.this.m_templateIdentifier));
        }

        public void inMultiFragmentCallNode(MultiFragmentCallNode p_node) {
            CallStatement s = Analyzer.this.makeCallStatement(p_node);
            Analyzer.this.addStatement(s);
            Analyzer.this.pushCallStatement(s);
        }

        public void outMultiFragmentCallNode(MultiFragmentCallNode p_call) {
            Analyzer.this.popCallStatement();
        }

        public void inNamedFragmentNode(NamedFragmentNode p_node) {
            Analyzer.this.getCurrentCallStatement().addFragmentImpl(Analyzer.this.pushFragmentUnitImpl(p_node.getName(), p_node.getLocation()), Analyzer.this.m_errors);
        }

        public void outNamedFragmentNode(NamedFragmentNode p_node) {
            Analyzer.this.popStatementBlock();
        }

        public void inFragmentCallNode(FragmentCallNode p_node) {
            CallStatement s = Analyzer.this.makeCallStatement(p_node);
            Analyzer.this.addStatement(s);
            s.addFragmentImpl(Analyzer.this.pushFragmentUnitImpl(null, p_node.getLocation()), Analyzer.this.m_errors);
        }

        public void outFragmentCallNode(FragmentCallNode p_node) {
            Analyzer.this.popStatementBlock();
        }

        public void inWhileNode(WhileNode p_node) {
            Analyzer.this.pushFlowControlBlock(p_node.getLocation(), "while (" + p_node.getCondition() + ")");
        }

        public void outWhileNode(WhileNode p_node) {
            Analyzer.this.popStatementBlock();
        }

        public void inForNode(ForNode p_node) {
            Analyzer.this.pushFlowControlBlock(p_node.getLocation(), "for (" + p_node.getLoopSpecifier() + ")");
        }

        public void outForNode(ForNode p_node) {
            Analyzer.this.popStatementBlock();
        }

        public void inIfNode(IfNode p_node) {
            Analyzer.this.pushFlowControlBlock(p_node.getLocation(), "if (" + p_node.getCondition() + ")");
        }

        public void outIfNode(IfNode p_node) {
            Analyzer.this.popStatementBlock();
        }

        public void inElseIfNode(ElseIfNode p_node) {
            Analyzer.this.pushFlowControlBlock(p_node.getLocation(), "else if (" + p_node.getCondition() + ")");
        }

        public void outElseIfNode(ElseIfNode p_node) {
            Analyzer.this.popStatementBlock();
        }

        public void inElseNode(ElseNode p_node) {
            Analyzer.this.pushFlowControlBlock(p_node.getLocation(), "else");
        }

        public void outElseNode(ElseNode p_node) {
            Analyzer.this.popStatementBlock();
        }

        public void outTopNode(TopNode p_node) {
        }

        public void caseJavaNode(JavaNode p_node) {
            Analyzer.this.addStatement(new RawStatement(p_node.getJava(), p_node.getLocation(), Analyzer.this.m_templateIdentifier));
        }

        public void caseEmitNode(EmitNode p_node) {
            Analyzer.this.addStatement(new WriteStatement(p_node.getEmitExpression(), new EmitAdapter().getEscape(p_node.getEscaping()), p_node.getLocation(), Analyzer.this.m_templateIdentifier, Analyzer.this.m_emitMode));
        }

        private class EmitAdapter
        extends AnalysisAdapter {
            EscapingDirective m_escapeCode = null;

            private EmitAdapter() {
            }

            public void caseEscapeNode(EscapeNode p_node) {
                this.m_escapeCode = EscapingDirective.get(p_node.getEscapeCode());
                if (this.m_escapeCode == null) {
                    Analyzer.this.addError("Unknown escaping directive '" + p_node.getEscapeCode() + "'", p_node.getLocation());
                }
            }

            public void caseDefaultEscapeNode(DefaultEscapeNode p_node) {
                this.m_escapeCode = Analyzer.this.getDefaultEscaping();
            }

            public EscapingDirective getEscape(AbstractEscapeNode p_node) {
                p_node.apply(this);
                return this.m_escapeCode;
            }
        }
    }

    private class PreliminaryAdapter
    extends AnalysisAdapter {
        private PreliminaryAdapter() {
        }

        public void caseEscapeDirectiveNode(EscapeDirectiveNode p_escape) {
            if (Analyzer.this.m_defaultEscaping != null) {
                Analyzer.this.addError("a template cannot specify multiple default escapings", p_escape.getLocation());
            }
            Analyzer.this.m_defaultEscaping = EscapingDirective.get(p_escape.getEscapeCode());
            if (Analyzer.this.m_defaultEscaping == null) {
                Analyzer.this.addError("Unknown escaping directive '" + p_escape.getEscapeCode() + "'", p_escape.getLocation());
            }
        }

        public void caseExtendsNode(ExtendsNode p_extends) {
            if (Analyzer.this.getTemplateUnit().hasParentPath()) {
                Analyzer.this.addError("a template cannot extend multiple templates", p_extends.getLocation());
            }
            String parentPath = Analyzer.this.getAbsolutePath(Analyzer.this.computePath(p_extends.getPath()));
            Analyzer.this.getTemplateUnit().setParentPath(parentPath);
            if (Analyzer.this.m_children.contains(parentPath)) {
                Analyzer.this.addError("cyclic inheritance involving " + parentPath, p_extends.getLocation());
            } else {
                Analyzer.this.m_children.add(parentPath);
                try {
                    Analyzer.this.getTemplateUnit().setParentDescription(Analyzer.this.m_describer.getTemplateDescription(parentPath, p_extends.getLocation(), Analyzer.this.m_children));
                }
                catch (ParserErrorImpl e) {
                    Analyzer.this.m_errors.addError(e);
                }
                catch (ParserErrorsImpl e) {
                    Analyzer.this.m_errors.addErrors(e);
                }
                catch (IOException e) {
                    Analyzer.this.addError(e.getMessage(), p_extends.getLocation());
                }
            }
        }

        public void caseAnnotationNode(AnnotationNode p_node) {
            Analyzer.this.m_templateUnit.addAnnotationNode(p_node);
        }

        public void caseParentMarkerNode(ParentMarkerNode p_node) {
            Analyzer.this.getTemplateUnit().setIsParent();
        }

        public void caseDefNode(DefNode p_node) {
            Analyzer.this.getTemplateUnit().makeDefUnit(p_node.getName(), p_node.getLocation());
        }

        public void caseMethodNode(MethodNode p_node) {
            Analyzer.this.getTemplateUnit().makeMethodUnit(p_node.getName(), p_node.getLocation(), false);
        }

        public void caseAbsMethodNode(AbsMethodNode p_node) {
            Analyzer.this.getTemplateUnit().makeMethodUnit(p_node.getName(), p_node.getLocation(), true);
        }
    }

    private class AliasAdapter
    extends AnalysisAdapter {
        private AliasAdapter() {
        }

        public void caseAliasesNode(AliasesNode p_node) {
            for (AliasDefNode defNode : p_node.getAliass()) {
                this.handleAlias(defNode);
            }
        }

        private void handleAlias(AliasDefNode p_node) {
            if (Analyzer.this.m_aliases.containsKey(p_node.getName())) {
                Analyzer.this.addError("Duplicate alias for " + p_node.getName(), p_node.getLocation());
            } else {
                Analyzer.this.m_aliases.put(p_node.getName(), Analyzer.this.computePath(p_node.getPath()));
            }
        }
    }
}

