/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.GenericsBoundNode;
import org.jamon.node.GenericsNode;
import org.jamon.node.GenericsParamNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.PositionalPushbackReader;

public class GenericsParser
extends AbstractParser {
    static final String EXPECTING_EXTENDS_OR_GENERIC_ERROR = "expecting ',', 'extends' or '</%generic>";
    static final String TYPE_PARAMETER_EXPECTED_ERROR = "type parameter expected";
    static final String EXPECTING_GENERIC_ERROR = "expecting '</%generic>'";
    private final GenericsNode m_genericsNode;

    public GenericsParser(PositionalPushbackReader p_reader, ParserErrorsImpl p_errors, Location p_tagLocation) throws IOException {
        super(p_reader, p_errors);
        this.m_genericsNode = new GenericsNode(p_tagLocation);
        this.checkForTagClosure(p_tagLocation);
        block7: while (true) {
            this.soakWhitespace();
            this.m_reader.markNodeEnd();
            String paramName = null;
            try {
                paramName = this.readIdentifierOrThrow();
            }
            catch (AbstractParser.NotAnIdentifierException e) {
                this.addError(this.m_reader.getCurrentNodeLocation(), TYPE_PARAMETER_EXPECTED_ERROR);
                return;
            }
            GenericsParamNode param = new GenericsParamNode(this.m_reader.getCurrentNodeLocation(), paramName);
            this.m_genericsNode.addParam(param);
            this.soakWhitespace();
            int c = this.m_reader.read();
            switch (c) {
                case 44: {
                    break;
                }
                case 60: {
                    if (!this.checkToken("/%generic>")) {
                        this.addError(this.m_reader.getLocation(), EXPECTING_EXTENDS_OR_GENERIC_ERROR);
                    }
                    this.soakWhitespace();
                    return;
                }
                case 101: {
                    if (this.checkToken("xtends")) {
                        if (!this.soakWhitespace()) {
                            this.addError(this.m_reader.getLocation(), EXPECTING_EXTENDS_OR_GENERIC_ERROR);
                            return;
                        }
                        boolean readingBounds = true;
                        while (readingBounds) {
                            this.m_reader.markNodeEnd();
                            String bound = this.readClassName(this.m_reader.getNextLocation());
                            if (bound.length() == 0) {
                                return;
                            }
                            param.addBound(new GenericsBoundNode(this.m_reader.getCurrentNodeLocation(), bound));
                            this.soakWhitespace();
                            readingBounds = this.readChar('&');
                            if (!readingBounds) continue;
                            this.soakWhitespace();
                        }
                        if (this.readChar(',')) continue block7;
                        if (!this.checkToken("</%generic>")) {
                            this.addError(this.m_reader.getLocation(), EXPECTING_GENERIC_ERROR);
                        }
                        this.soakWhitespace();
                        return;
                    }
                    this.addError(this.m_reader.getLocation(), EXPECTING_EXTENDS_OR_GENERIC_ERROR);
                    return;
                }
                default: {
                    this.addError(this.m_reader.getLocation(), EXPECTING_EXTENDS_OR_GENERIC_ERROR);
                    return;
                }
            }
        }
    }

    public GenericsNode getGenericsNode() {
        return this.m_genericsNode;
    }
}

