/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jamon.util.JavaCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalJavaCompiler
implements JavaCompiler {
    private final List<String> m_compilerCommand;

    public ExternalJavaCompiler(String p_javac, List<String> p_compilerArgs) {
        this.m_compilerCommand = new ArrayList<String>(p_compilerArgs.size() + 1);
        this.m_compilerCommand.add(p_javac);
        this.m_compilerCommand.addAll(p_compilerArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String compile(String[] p_javaFiles) {
        Process p;
        String[] cmdline = new String[p_javaFiles.length + this.m_compilerCommand.size()];
        this.m_compilerCommand.toArray(cmdline);
        System.arraycopy(p_javaFiles, 0, cmdline, this.m_compilerCommand.size(), p_javaFiles.length);
        try {
            p = Runtime.getRuntime().exec(cmdline);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        StreamConsumer stderr = new StreamConsumer(p.getErrorStream());
        try {
            Thread errThread = new Thread(stderr);
            errThread.start();
            int code = -1;
            try {
                code = p.waitFor();
            }
            catch (InterruptedException e) {
                errThread.interrupt();
            }
            try {
                errThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            String string = code == 0 ? null : stderr.getContents();
            return string;
        }
        finally {
            try {
                stderr.close();
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }
    }

    private static class StreamConsumer
    implements Runnable {
        private final InputStream m_stream;
        private final StringBuilder m_buffer = new StringBuilder();

        StreamConsumer(InputStream p_stream) {
            this.m_stream = p_stream;
        }

        private void close() throws IOException {
            this.m_stream.close();
        }

        synchronized String getContents() {
            return this.m_buffer.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buf = new byte[1024];
            boolean eof = false;
            while (!eof) {
                try {
                    int read = this.m_stream.read(buf);
                    if (read == -1) {
                        eof = true;
                        continue;
                    }
                    if (read == 0) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            eof = true;
                        }
                        continue;
                    }
                    StringBuilder stringBuilder = this.m_buffer;
                    synchronized (stringBuilder) {
                        this.m_buffer.append(new String(buf, 0, read));
                    }
                }
                catch (IOException e) {
                    eof = true;
                }
            }
        }
    }
}

