package org.jamon.node;

import org.jamon.api.Location;
public class ExtendsNode extends AbstractNode {
  public ExtendsNode(Location location, AbstractPathNode path) {
    super(location);
    if ((this.path = path) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseExtendsNode(this);
  }

  private final AbstractPathNode path;
  public AbstractPathNode getPath() { return path; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && path.equals(((ExtendsNode) obj).path)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ path.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "path", path);
  }

}
