package org.jamon.node;

import org.jamon.api.Location;
public class ForNode extends AbstractBodyNode {
  public ForNode(Location location, String loopSpecifier) {
    super(location);
    if ((this.loopSpecifier = loopSpecifier) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseForNode(this);
  }

  private final String loopSpecifier;
  public String getLoopSpecifier() { return loopSpecifier; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && loopSpecifier.equals(((ForNode) obj).loopSpecifier)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ loopSpecifier.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "loopSpecifier", loopSpecifier);
  }

}
