package org.jamon.node;

import org.jamon.api.Location;
public class FragmentCallNode extends AbstractComponentCallNode {
  public FragmentCallNode(Location location, AbstractPathNode callPath, AbstractParamsNode params, UnnamedFragmentNode fragment) {
    super(location, callPath, params);
    if ((this.fragment = fragment) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseFragmentCallNode(this);
  }

  private final UnnamedFragmentNode fragment;
  public UnnamedFragmentNode getFragment() { return fragment; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && fragment.equals(((FragmentCallNode) obj).fragment)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ fragment.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "fragment", fragment);
  }

}
