package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class GenericsParamNode extends AbstractNode {
  public GenericsParamNode(Location location, String name) {
    super(location);
    if ((this.name = name) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseGenericsParamNode(this);
  }

  private final String name;
  public String getName() { return name; }

  private final List<GenericsBoundNode> bounds = new ArrayList<GenericsBoundNode>();
  public GenericsParamNode addBound(GenericsBoundNode bound) {
    if (bound == null) { throw new NullPointerException(); }
    bounds.add(bound);
    return this;
  }
  public List<GenericsBoundNode> getBounds() { return bounds; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && name.equals(((GenericsParamNode) obj).name)
      && bounds.equals(((GenericsParamNode) obj).bounds)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ name.hashCode()
      ^ bounds.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "name", name);
    addPropertyList(buffer, "bound", bounds);
  }

}
