package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class ImplementsNode extends AbstractNode {
  public ImplementsNode(Location location) {
    super(location);
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseImplementsNode(this);
  }

  private final List<ImplementNode> _implements = new ArrayList<ImplementNode>();
  public ImplementsNode addImplement(ImplementNode implement) {
    if (implement == null) { throw new NullPointerException(); }
    _implements.add(implement);
    return this;
  }
  public List<ImplementNode> getImplements() { return _implements; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && _implements.equals(((ImplementsNode) obj)._implements)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ _implements.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addPropertyList(buffer, "implement", _implements);
  }

}
