package org.jamon.node;

import org.jamon.api.Location;
public class LiteralNode extends AbstractNode {
  public LiteralNode(Location location, String text) {
    super(location);
    if ((this.text = text) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseLiteralNode(this);
  }

  private final String text;
  public String getText() { return text; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && text.equals(((LiteralNode) obj).text)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ text.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "text", text);
  }

}
