package org.jamon.node;

import org.jamon.api.Location;
public class NamedParamNode extends AbstractNode {
  public NamedParamNode(Location location, ParamNameNode name, ParamValueNode value) {
    super(location);
    if ((this.name = name) == null)
      { throw new NullPointerException(); }
    if ((this.value = value) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseNamedParamNode(this);
  }

  private final ParamNameNode name;
  public ParamNameNode getName() { return name; }

  private final ParamValueNode value;
  public ParamValueNode getValue() { return value; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && name.equals(((NamedParamNode) obj).name)
      && value.equals(((NamedParamNode) obj).value)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ name.hashCode()
      ^ value.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "name", name);
    addProperty(buffer, "value", value);
  }

}
