package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class NamedParamsNode extends AbstractParamsNode {
  public NamedParamsNode(Location location) {
    super(location);
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseNamedParamsNode(this);
  }

  private final List<NamedParamNode> params = new ArrayList<NamedParamNode>();
  public NamedParamsNode addParam(NamedParamNode param) {
    if (param == null) { throw new NullPointerException(); }
    params.add(param);
    return this;
  }
  public List<NamedParamNode> getParams() { return params; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && params.equals(((NamedParamsNode) obj).params)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ params.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addPropertyList(buffer, "param", params);
  }

}
