package org.jamon.node;

import org.jamon.api.Location;
public class OptionalArgNode extends ArgNode {
  public OptionalArgNode(Location location, ArgTypeNode type, ArgNameNode name, ArgValueNode value) {
    super(location, type, name);
    if ((this.value = value) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseOptionalArgNode(this);
  }

  private final ArgValueNode value;
  public ArgValueNode getValue() { return value; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && value.equals(((OptionalArgNode) obj).value)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ value.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "value", value);
  }

}
