package org.jamon.node;

import org.jamon.api.Location;
public class TopNode extends AbstractBodyNode {
  public TopNode(Location location, String encoding) {
    super(location);
    if ((this.encoding = encoding) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseTopNode(this);
  }

  private final String encoding;
  public String getEncoding() { return encoding; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && encoding.equals(((TopNode) obj).encoding)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ encoding.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "encoding", encoding);
  }

}
