/**
 * Copyright 2007 The JA-SIG Collaborative.  All rights reserved.
 * See license distributed with this file and
 * available online at http://www.uportal.org/license.html
 */
package org.jasig.web.util;

import java.util.Map;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Provides functionality for passing an object model from a portlet {@link ActonRequest} to
 * a {@link HttpServletRequest}
 * 
 * @author Eric Dalquist
 * @version $Revision$
 */
public interface ModelPasser {
    /**
     * Take the key and model for the request and store it in a way that a servlet in the same
     * web application.
     * 
     * @param key A session-unique key that can be used for passing the model
     * @param model The model that needs to be passed to the servlet.
     */
    public void passModelToServlet(ActionRequest request, ActionResponse response, String key, Map<Object, Object> model);
    
    /**
     * Retrieve a model for the specified key passed from a portlet in the same web application.
     * 
     * @param key The session-unique key to retrieve the model for
     * @return The model for the key, if no model is found null is returned.
     */
    public Map<Object, Object> getModelFromPortlet(HttpServletRequest request, HttpServletResponse response, String key);
}
