/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.web.util;

import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.web.util.ModelPasser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelPasser
implements ModelPasser {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Map<Object, Object> getModelFromPortlet(HttpServletRequest request, HttpServletResponse response, String key) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this.logger.debug((Object)("No session available, returning null for key '" + key + "'"));
            return null;
        }
        Map model = (Map)session.getAttribute(key);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found model '" + model + "' in HttpSession for key '" + key + "'"));
        }
        session.removeAttribute(key);
        return model;
    }

    @Override
    public void passModelToServlet(ActionRequest request, ActionResponse response, String key, Map<Object, Object> model) {
        PortletSession portletSession = request.getPortletSession();
        portletSession.setAttribute(key, model, 1);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Stored model '" + model + "' in PortletSession for key '" + key + "' at the application scope"));
        }
    }
}

