/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog;

import com.thoughtworks.xstream.XStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.irclog.EventLogBot;
import org.jasig.irclog.config.ChannelLogger;
import org.jasig.irclog.config.ConfluenceServer;
import org.jasig.irclog.config.IrcServer;
import org.jasig.irclog.config.LogBotConfig;
import org.jasig.irclog.config.Nick;
import org.jasig.irclog.events.handlers.ChannelManager;
import org.jasig.irclog.events.handlers.ChannelNotifier;
import org.jasig.irclog.events.handlers.FilteringEventHandler;
import org.jasig.irclog.events.handlers.FormattingEventHandler;
import org.jasig.irclog.events.handlers.NickAuthHandler;
import org.jasig.irclog.events.handlers.SplittingEventHandler;
import org.jasig.irclog.events.handlers.filter.ChannelEventFilter;
import org.jasig.irclog.events.handlers.filter.OrFilter;
import org.jasig.irclog.events.handlers.filter.SelfTargetedEventFilter;
import org.jasig.irclog.events.handlers.filter.TargetedEventFilter;
import org.jasig.irclog.messages.BufferingMessageHandler;
import org.jasig.irclog.messages.ConfluenceMessageHandler;
import org.jasig.irclog.messages.LoggingMessageHandler;
import org.jasig.irclog.messages.XmlEscapingMessageHandler;
import org.jasig.irclog.messages.support.MessageHandlerFlusher;

public class BotRunner {
    private static final String EVENT_FORMATING_PROPERTIES = "/confluenceEventFormating.properties";
    private static final Log LOG = LogFactory.getLog(BotRunner.class);

    public static void main(String[] args) throws IOException {
        LogBotConfig botConfig = BotRunner.loadConfig(args);
        if (botConfig == null) {
            return;
        }
        EventLogBot bot = BotRunner.setupLogBot(botConfig);
        IrcServer ircServer = botConfig.getIrcServer();
        String host = ircServer.getHost();
        String port = ircServer.getPort();
        String password = ircServer.getPassword();
        try {
            if (port != null && password != null) {
                bot.connect(host, Integer.parseInt(port), password);
            } else if (password != null) {
                bot.connect(host, 6667, password);
            } else if (port != null) {
                bot.connect(host, Integer.parseInt(port));
            } else {
                bot.connect(host);
            }
        }
        catch (Exception e) {
            LOG.error((Object)((Object)((Object)bot) + " failed with following exception."), (Throwable)e);
        }
    }

    private static EventLogBot setupLogBot(LogBotConfig botConfig) {
        Properties eventFormats = BotRunner.getEventFormats();
        EventLogBot bot = new EventLogBot();
        SplittingEventHandler splittingEventHandler = new SplittingEventHandler();
        bot.setEventHandler(splittingEventHandler);
        ChannelManager channelManager = new ChannelManager();
        splittingEventHandler.registerEventHandler(channelManager);
        ChannelNotifier channelNotifier = new ChannelNotifier();
        splittingEventHandler.registerEventHandler(channelNotifier);
        NickAuthHandler nickAuthHandler = new NickAuthHandler();
        Nick nick = botConfig.getNick();
        nickAuthHandler.addPassword(nick.getName(), nick.getPassword());
        splittingEventHandler.registerEventHandler(nickAuthHandler);
        LoggingMessageHandler loggingMessageHandler = new LoggingMessageHandler();
        FormattingEventHandler logFormattingEventHandler = new FormattingEventHandler();
        logFormattingEventHandler.setEventFormats(eventFormats);
        logFormattingEventHandler.setMessageHandler(loggingMessageHandler);
        FilteringEventHandler logFilteringEventHandler = new FilteringEventHandler();
        logFilteringEventHandler.setEventFilter(new SelfTargetedEventFilter());
        logFilteringEventHandler.setTargetHandler(logFormattingEventHandler);
        splittingEventHandler.registerEventHandler(logFilteringEventHandler);
        for (ChannelLogger channelLogger : botConfig.getChannelLoggers()) {
            String channel = channelLogger.getIrcChannel();
            channelManager.addChannel(channel);
            String message = channelLogger.getNotification();
            channelNotifier.addOnJoinMessage(channel, message);
            ConfluenceMessageHandler confluenceMessageHandler = new ConfluenceMessageHandler();
            confluenceMessageHandler.setConfluenceServer(channelLogger.getConfluenceServer());
            confluenceMessageHandler.setLogPagesTitleFormats(channelLogger.getLogPagesTitleFormats());
            confluenceMessageHandler.setSpaceKey(channelLogger.getSpaceKey());
            BufferingMessageHandler bufferingMessageHandler = new BufferingMessageHandler();
            bufferingMessageHandler.setMessageBufferSize(64);
            bufferingMessageHandler.setMessageHandler(confluenceMessageHandler);
            MessageHandlerFlusher messageHandlerFlusher = new MessageHandlerFlusher();
            messageHandlerFlusher.setPeriod(300);
            messageHandlerFlusher.setMessageHandler(bufferingMessageHandler);
            XmlEscapingMessageHandler xmlEscapingMessageHandler = new XmlEscapingMessageHandler();
            xmlEscapingMessageHandler.setMessageHandler(bufferingMessageHandler);
            FormattingEventHandler formattingEventHandler = new FormattingEventHandler();
            formattingEventHandler.setEventFormats(eventFormats);
            formattingEventHandler.setMessageHandler(xmlEscapingMessageHandler);
            FilteringEventHandler filteringEventHandler = new FilteringEventHandler();
            OrFilter orFilter = new OrFilter();
            orFilter.addFilter(new ChannelEventFilter(channel));
            orFilter.addFilter(new TargetedEventFilter(channel));
            filteringEventHandler.setEventFilter(orFilter);
            filteringEventHandler.setTargetHandler(formattingEventHandler);
            splittingEventHandler.registerEventHandler(filteringEventHandler);
        }
        bot.setBotName(nick.getName());
        bot.setAutoNickChange(true);
        return bot;
    }

    private static Properties getEventFormats() {
        InputStream eventFormatsStream = BotRunner.class.getResourceAsStream(EVENT_FORMATING_PROPERTIES);
        Properties eventFormats = new Properties();
        try {
            eventFormats.load(eventFormatsStream);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Cannot load event formats Properties file: /confluenceEventFormating.properties", ioe);
        }
        return eventFormats;
    }

    private static LogBotConfig loadConfig(String[] args) throws FileNotFoundException {
        Options options = new Options();
        Option configFileOpt = new Option("c", "Configuration File");
        configFileOpt.setLongOpt("config");
        configFileOpt.setRequired(true);
        configFileOpt.setArgs(1);
        options.addOption(configFileOpt);
        try {
            PosixParser parser = new PosixParser();
            parser.parse(options, args);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java " + BotRunner.class.getName(), options, true);
            return null;
        }
        String configFilePath = configFileOpt.getValue();
        FileInputStream configInputStream = new FileInputStream(configFilePath);
        XStream xstream = BotRunner.getConfigParser();
        return (LogBotConfig)xstream.fromXML((InputStream)configInputStream);
    }

    private static XStream getConfigParser() {
        XStream xstream = new XStream();
        xstream.alias("logBotConfig", LogBotConfig.class);
        xstream.alias("nick", Nick.class);
        xstream.alias("ircServer", IrcServer.class);
        xstream.alias("channelLogger", ChannelLogger.class);
        xstream.alias("confluenceServer", ConfluenceServer.class);
        xstream.alias("class", Class.class);
        return xstream;
    }
}

