/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleService;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.InvalidProxyChainValidationException;
import org.jasig.cas.client.validation.ValidationException;

public class Cas20ProxyTicketValidator
extends Cas20ServiceTicketValidator {
    private final List proxyChains;
    private final boolean acceptAnyProxy;

    public Cas20ProxyTicketValidator(String casServerUrl, boolean renew, HttpClient httpClient, List proxyChains, boolean acceptAnyProxy) {
        this(casServerUrl, renew, httpClient, null, proxyChains, acceptAnyProxy, null, null);
    }

    public Cas20ProxyTicketValidator(String casServerUrl, boolean renew, HttpClient httpClient, Service proxyCallbackUrl, List proxyChains, boolean acceptAnyProxy, ProxyGrantingTicketStorage proxyGrantingTicketStorage, ProxyRetriever proxyRetriever) {
        super(casServerUrl, renew, httpClient, proxyCallbackUrl, proxyGrantingTicketStorage, proxyRetriever);
        CommonUtils.assertTrue(proxyChains != null || acceptAnyProxy, "proxyChains cannot be null or acceptAnyProxy must be true.");
        CommonUtils.assertTrue(proxyChains != null && !proxyChains.isEmpty() || acceptAnyProxy, "proxyChains cannot be empty or acceptAnyProxy must be true.");
        ArrayList<Service[]> tempProxyChains = new ArrayList<Service[]>(proxyChains.size() * 2);
        Iterator iter = proxyChains.iterator();
        while (iter.hasNext()) {
            String[] values = ((String)iter.next()).split(" ");
            Service[] principals = new Service[values.length];
            for (int i = 0; i < principals.length; ++i) {
                principals[i] = new SimpleService(values[i]);
            }
            tempProxyChains.add(principals);
        }
        this.proxyChains = tempProxyChains;
        this.acceptAnyProxy = acceptAnyProxy;
    }

    protected String getValidationUrlName() {
        return "proxyValidate";
    }

    protected Assertion getValidAssertionInternal(String response, String principal, String proxyGrantingTicketIou) throws ValidationException {
        List proxies = XmlUtils.getTextForElements(response, "proxy");
        if (proxies.isEmpty() || this.acceptAnyProxy) {
            return this.getAssertionBasedOnProxyGrantingTicketIou(proxyGrantingTicketIou, principal);
        }
        Object[] principals = new Service[proxies.size()];
        int i = 0;
        Iterator iter = proxies.iterator();
        while (iter.hasNext()) {
            principals[i++] = new SimpleService((String)iter.next());
        }
        iter = this.proxyChains.iterator();
        while (iter.hasNext()) {
            if (!Arrays.equals(principals, (Object[])iter.next())) continue;
            return this.getAssertionBasedOnProxyGrantingTicketIou(proxyGrantingTicketIou, principal);
        }
        throw new InvalidProxyChainValidationException();
    }
}

