/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.util.CommonUtils;

public abstract class AbstractCasFilter
implements Filter {
    public static final String PARAM_TICKET = "ticket";
    public static final String CONST_ASSERTION = "_cas_assertion_";
    public static final String CONST_GATEWAY = "_cas_gateway_";
    public static final String CONST_PRINCIPAL = "_cas_principal_";
    protected final Log log = LogFactory.getLog(this.getClass());
    private final String serverName;
    private final String serviceUrl;
    private final boolean useSession;

    protected AbstractCasFilter(String serverName, String serviceUrl) {
        this(serverName, serviceUrl, true);
    }

    protected AbstractCasFilter(String serverName, String serviceUrl, boolean useSession) {
        CommonUtils.assertTrue(CommonUtils.isNotBlank(serverName) || CommonUtils.isNotBlank(serviceUrl), "either serverName or serviceUrl must be set");
        this.serverName = serverName;
        this.serviceUrl = serviceUrl;
        this.useSession = useSession;
        this.log.info((Object)("Service Name set to: " + this.serverName + "; Service Url  set to: " + this.serviceUrl + "Use Session set to: " + this.useSession));
    }

    public final void destroy() {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.doFilterInternal((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
    }

    protected abstract void doFilterInternal(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String constructServiceUrl(HttpServletRequest request, HttpServletResponse response) {
        StringBuffer buffer;
        if (CommonUtils.isNotBlank(this.serviceUrl)) {
            return response.encodeURL(this.serviceUrl);
        }
        StringBuffer stringBuffer = buffer = new StringBuffer();
        synchronized (stringBuffer) {
            buffer.append(request.isSecure() ? "https://" : "http://");
            buffer.append(this.serverName);
            buffer.append(request.getRequestURI());
            if (CommonUtils.isNotBlank(request.getQueryString())) {
                int location = request.getQueryString().indexOf("ticket=");
                if (location == 0) {
                    String returnValue = response.encodeURL(buffer.toString());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("serviceUrl generated: " + returnValue));
                    }
                    return returnValue;
                }
                buffer.append("?");
                if (location == -1) {
                    buffer.append(request.getQueryString());
                } else if (location > 0) {
                    int actualLocation = request.getQueryString().indexOf("&ticket=");
                    if (actualLocation == -1) {
                        buffer.append(request.getQueryString());
                    } else if (actualLocation > 0) {
                        buffer.append(request.getQueryString().substring(0, actualLocation));
                    }
                }
            }
        }
        String returnValue = response.encodeURL(buffer.toString());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("serviceUrl generated: " + returnValue));
        }
        return returnValue;
    }

    protected final boolean isUseSession() {
        return this.useSession;
    }
}

