/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.web.filter;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.web.filter.AbstractCasFilter;

public final class AuthenticationFilter
extends AbstractCasFilter {
    private final String casServerLoginUrl;
    private final boolean renew;
    private final boolean gateway;

    public AuthenticationFilter(String serverName, String serviceUrl, String casServerLoginUrl) {
        this(serverName, serviceUrl, true, casServerLoginUrl, false, false);
    }

    public AuthenticationFilter(String serverName, String serviceUrl, String casServerLoginUrl, boolean renew, boolean gateway) {
        this(serverName, serviceUrl, true, casServerLoginUrl, renew, gateway);
    }

    public AuthenticationFilter(String serverName, String serviceUrl, boolean useSession, String casServerLoginUrl, boolean renew, boolean gateway) {
        super(serverName, serviceUrl, useSession);
        CommonUtils.assertNotNull(casServerLoginUrl, "the CAS Server Login URL cannot be null.");
        this.casServerLoginUrl = casServerLoginUrl;
        this.renew = renew;
        this.gateway = gateway;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean wasGatewayed;
        HttpSession session = request.getSession(this.isUseSession());
        String ticket = request.getParameter("ticket");
        Assertion assertion = session != null ? (Assertion)session.getAttribute("_cas_assertion_") : null;
        boolean bl = wasGatewayed = session != null && session.getAttribute("_cas_gateway_") != null;
        if (CommonUtils.isBlank(ticket) && assertion == null && !wasGatewayed) {
            this.log.debug((Object)"no ticket and no assertion found");
            if (this.gateway && session != null) {
                this.log.debug((Object)"setting gateway attribute in session");
                session.setAttribute("_cas_gateway_", (Object)"yes");
            }
            String serviceUrl = this.constructServiceUrl(request, response);
            String urlToRedirectTo = this.casServerLoginUrl + "?service=" + URLEncoder.encode(serviceUrl, "UTF-8") + (this.renew ? "&renew=true" : "") + (this.gateway ? "&gateway=true" : "");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("redirecting to \"" + urlToRedirectTo + "\""));
            }
            response.sendRedirect(urlToRedirectTo);
            return;
        }
        if (session != null) {
            this.log.debug((Object)"removing gateway attribute from session");
            session.setAttribute("_cas_gateway_", null);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

