/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleService;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidator;
import org.jasig.cas.client.validation.ValidationException;
import org.jasig.cas.client.web.filter.AbstractCasFilter;

public final class TicketValidationFilter
extends AbstractCasFilter {
    private final TicketValidator ticketValidator;
    private final boolean redirectAfterValidation;

    public TicketValidationFilter(String serverName, String serviceUrl, TicketValidator ticketValidator) {
        this(serverName, serviceUrl, true, ticketValidator, false);
    }

    public TicketValidationFilter(String serverName, String serviceUrl, boolean useSession, TicketValidator ticketValidator, boolean redirectAfterValidation) {
        super(serverName, serviceUrl, useSession);
        CommonUtils.assertNotNull(ticketValidator, "ticketValidator cannot be null.");
        this.ticketValidator = ticketValidator;
        this.redirectAfterValidation = redirectAfterValidation;
        this.log.info((Object)("Initialized with the following properties:  ticketValidator=" + this.ticketValidator.getClass().getName() + "; " + "redirectAfterValidation=" + this.redirectAfterValidation));
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String ticket = request.getParameter("ticket");
        if (CommonUtils.isNotBlank(ticket)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting to validate ticket: " + ticket));
            }
            try {
                Assertion assertion = this.ticketValidator.validate(ticket, (Service)new SimpleService(this.constructServiceUrl(request, response)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Successfully authenticated user: " + assertion.getPrincipal().getId()));
                }
                request.setAttribute("_cas_principal_", (Object)assertion.getPrincipal());
                if (this.isUseSession()) {
                    request.getSession().setAttribute("_cas_assertion_", (Object)assertion);
                }
            }
            catch (ValidationException e) {
                response.setStatus(403);
                this.log.warn((Object)e, (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            if (this.redirectAfterValidation) {
                response.sendRedirect(response.encodeRedirectURL(this.constructServiceUrl(request, response)));
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

