/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.session;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.session.SingleSignOutFilter;

public final class SingleSignOutHttpSessionListener
implements HttpSessionListener {
    private Log log = LogFactory.getLog(this.getClass());
    private SessionMappingStorage SESSION_MAPPING_STORAGE;

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (this.SESSION_MAPPING_STORAGE == null) {
            this.SESSION_MAPPING_STORAGE = SingleSignOutHttpSessionListener.getSessionMappingStorage();
        }
        HttpSession session = event.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing HttpSession: " + session.getId()));
        }
        this.SESSION_MAPPING_STORAGE.removeBySessionById(session.getId());
    }

    protected static SessionMappingStorage getSessionMappingStorage() {
        return SingleSignOutFilter.getSessionMappingStorage();
    }
}

